/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CatSegmentsColumn;
import co.elastic.clients.elasticsearch.cat.SegmentsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SegmentsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowClosed;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Bytes bytes;
    private final List<ExpandWildcard> expandWildcards;
    private final List<String> h;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<SegmentsRequest, SegmentsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SegmentsRequest, SegmentsResponse>("es/cat.segments", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/segments");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/segments");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.allowClosed != null) {
            params.put("allow_closed", String.valueOf(request.allowClosed));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SegmentsResponse._DESERIALIZER);

    private SegmentsRequest(Builder builder) {
        this.allowClosed = builder.allowClosed;
        this.allowNoIndices = builder.allowNoIndices;
        this.bytes = builder.bytes;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static SegmentsRequest of(Function<Builder, ObjectBuilder<SegmentsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowClosed() {
        return this.allowClosed;
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    public final List<String> h() {
        return this.h;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SegmentsRequest> {
        @Nullable
        private Boolean allowClosed;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private List<String> h;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(SegmentsRequest instance) {
            this.allowClosed = instance.allowClosed;
            this.allowNoIndices = instance.allowNoIndices;
            this.bytes = instance.bytes;
            this.expandWildcards = instance.expandWildcards;
            this.h = instance.h;
            this.ignoreThrottled = instance.ignoreThrottled;
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.index = instance.index;
            this.local = instance.local;
            this.masterTimeout = instance.masterTimeout;
            this.s = instance.s;
            this.time = instance.time;
        }

        public final Builder allowClosed(@Nullable Boolean value) {
            this.allowClosed = value;
            return this;
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder h(CatSegmentsColumn value, CatSegmentsColumn ... values) {
            this.h = Builder._listAdd(this.h, value.jsonValue(), (String[])Arrays.stream(values).map(CatSegmentsColumn::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SegmentsRequest build() {
            this._checkSingleUse();
            return new SegmentsRequest(this);
        }
    }
}

