/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FieldValueFactorModifier;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldValueFactorScoreFunction
implements FunctionScoreVariant,
JsonpSerializable {
    private final String field;
    @Nullable
    private final Double factor;
    @Nullable
    private final Double missing;
    @Nullable
    private final FieldValueFactorModifier modifier;
    public static final JsonpDeserializer<FieldValueFactorScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldValueFactorScoreFunction::setupFieldValueFactorScoreFunctionDeserializer);

    private FieldValueFactorScoreFunction(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.factor = builder.factor;
        this.missing = builder.missing;
        this.modifier = builder.modifier;
    }

    public static FieldValueFactorScoreFunction of(Function<Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.FieldValueFactor;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double factor() {
        return this.factor;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final FieldValueFactorModifier modifier() {
        return this.modifier;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.factor != null) {
            generator.writeKey("factor");
            generator.write(this.factor.doubleValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.modifier != null) {
            generator.writeKey("modifier");
            this.modifier.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldValueFactorScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::factor, JsonpDeserializer.doubleDeserializer(), "factor");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::modifier, FieldValueFactorModifier._DESERIALIZER, "modifier");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldValueFactorScoreFunction> {
        private String field;
        @Nullable
        private Double factor;
        @Nullable
        private Double missing;
        @Nullable
        private FieldValueFactorModifier modifier;

        public Builder() {
        }

        private Builder(FieldValueFactorScoreFunction instance) {
            this.field = instance.field;
            this.factor = instance.factor;
            this.missing = instance.missing;
            this.modifier = instance.modifier;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder factor(@Nullable Double value) {
            this.factor = value;
            return this;
        }

        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public final Builder modifier(@Nullable FieldValueFactorModifier value) {
            this.modifier = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldValueFactorScoreFunction build() {
            this._checkSingleUse();
            return new FieldValueFactorScoreFunction(this);
        }
    }
}

