/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.RankVectorElementType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankVectorProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final RankVectorElementType elementType;
    @Nullable
    private final Integer dims;
    public static final JsonpDeserializer<RankVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankVectorProperty::setupRankVectorPropertyDeserializer);

    private RankVectorProperty(Builder builder) {
        super(builder);
        this.elementType = builder.elementType;
        this.dims = builder.dims;
    }

    public static RankVectorProperty of(Function<Builder, ObjectBuilder<RankVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.RankVectors;
    }

    @Nullable
    public final RankVectorElementType elementType() {
        return this.elementType;
    }

    @Nullable
    public final Integer dims() {
        return this.dims;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "rank_vectors");
        super.serializeInternal(generator, mapper);
        if (this.elementType != null) {
            generator.writeKey("element_type");
            this.elementType.serialize(generator, mapper);
        }
        if (this.dims != null) {
            generator.writeKey("dims");
            generator.write(this.dims.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRankVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::elementType, RankVectorElementType._DESERIALIZER, "element_type");
        op.add(Builder::dims, JsonpDeserializer.integerDeserializer(), "dims");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RankVectorProperty> {
        @Nullable
        private RankVectorElementType elementType;
        @Nullable
        private Integer dims;

        public Builder() {
        }

        private Builder(RankVectorProperty instance) {
            this.elementType = instance.elementType;
            this.dims = instance.dims;
        }

        public final Builder elementType(@Nullable RankVectorElementType value) {
            this.elementType = value;
            return this;
        }

        public final Builder dims(@Nullable Integer value) {
            this.dims = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankVectorProperty build() {
            this._checkSingleUse();
            return new RankVectorProperty(this);
        }
    }
}

