/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptionsRescoreVector;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptionsType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorIndexOptions
implements JsonpSerializable {
    @Nullable
    private final Float confidenceInterval;
    @Nullable
    private final Integer efConstruction;
    @Nullable
    private final Integer m;
    private final DenseVectorIndexOptionsType type;
    @Nullable
    private final DenseVectorIndexOptionsRescoreVector rescoreVector;
    @Nullable
    private final Boolean onDiskRescore;
    public static final JsonpDeserializer<DenseVectorIndexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorIndexOptions::setupDenseVectorIndexOptionsDeserializer);

    private DenseVectorIndexOptions(Builder builder) {
        this.confidenceInterval = builder.confidenceInterval;
        this.efConstruction = builder.efConstruction;
        this.m = builder.m;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.rescoreVector = builder.rescoreVector;
        this.onDiskRescore = builder.onDiskRescore;
    }

    public static DenseVectorIndexOptions of(Function<Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float confidenceInterval() {
        return this.confidenceInterval;
    }

    @Nullable
    public final Integer efConstruction() {
        return this.efConstruction;
    }

    @Nullable
    public final Integer m() {
        return this.m;
    }

    public final DenseVectorIndexOptionsType type() {
        return this.type;
    }

    @Nullable
    public final DenseVectorIndexOptionsRescoreVector rescoreVector() {
        return this.rescoreVector;
    }

    @Nullable
    public final Boolean onDiskRescore() {
        return this.onDiskRescore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.confidenceInterval != null) {
            generator.writeKey("confidence_interval");
            generator.write((double)this.confidenceInterval.floatValue());
        }
        if (this.efConstruction != null) {
            generator.writeKey("ef_construction");
            generator.write(this.efConstruction.intValue());
        }
        if (this.m != null) {
            generator.writeKey("m");
            generator.write(this.m.intValue());
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (this.rescoreVector != null) {
            generator.writeKey("rescore_vector");
            this.rescoreVector.serialize(generator, mapper);
        }
        if (this.onDiskRescore != null) {
            generator.writeKey("on_disk_rescore");
            generator.write(this.onDiskRescore.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDenseVectorIndexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::confidenceInterval, JsonpDeserializer.floatDeserializer(), "confidence_interval");
        op.add(Builder::efConstruction, JsonpDeserializer.integerDeserializer(), "ef_construction");
        op.add(Builder::m, JsonpDeserializer.integerDeserializer(), "m");
        op.add(Builder::type, DenseVectorIndexOptionsType._DESERIALIZER, "type");
        op.add(Builder::rescoreVector, DenseVectorIndexOptionsRescoreVector._DESERIALIZER, "rescore_vector");
        op.add(Builder::onDiskRescore, JsonpDeserializer.booleanDeserializer(), "on_disk_rescore");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DenseVectorIndexOptions> {
        @Nullable
        private Float confidenceInterval;
        @Nullable
        private Integer efConstruction;
        @Nullable
        private Integer m;
        private DenseVectorIndexOptionsType type;
        @Nullable
        private DenseVectorIndexOptionsRescoreVector rescoreVector;
        @Nullable
        private Boolean onDiskRescore;

        public Builder() {
        }

        private Builder(DenseVectorIndexOptions instance) {
            this.confidenceInterval = instance.confidenceInterval;
            this.efConstruction = instance.efConstruction;
            this.m = instance.m;
            this.type = instance.type;
            this.rescoreVector = instance.rescoreVector;
            this.onDiskRescore = instance.onDiskRescore;
        }

        public final Builder confidenceInterval(@Nullable Float value) {
            this.confidenceInterval = value;
            return this;
        }

        public final Builder efConstruction(@Nullable Integer value) {
            this.efConstruction = value;
            return this;
        }

        public final Builder m(@Nullable Integer value) {
            this.m = value;
            return this;
        }

        public final Builder type(DenseVectorIndexOptionsType value) {
            this.type = value;
            return this;
        }

        public final Builder rescoreVector(@Nullable DenseVectorIndexOptionsRescoreVector value) {
            this.rescoreVector = value;
            return this;
        }

        public final Builder rescoreVector(Function<DenseVectorIndexOptionsRescoreVector.Builder, ObjectBuilder<DenseVectorIndexOptionsRescoreVector>> fn) {
            return this.rescoreVector(fn.apply(new DenseVectorIndexOptionsRescoreVector.Builder()).build());
        }

        public final Builder onDiskRescore(@Nullable Boolean value) {
            this.onDiskRescore = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorIndexOptions build() {
            this._checkSingleUse();
            return new DenseVectorIndexOptions(this);
        }
    }
}

