/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CharGroupTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    private final List<String> tokenizeOnChars;
    @Nullable
    private final Integer maxTokenLength;
    public static final JsonpDeserializer<CharGroupTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharGroupTokenizer::setupCharGroupTokenizerDeserializer);

    private CharGroupTokenizer(Builder builder) {
        super(builder);
        this.tokenizeOnChars = ApiTypeHelper.unmodifiableRequired(builder.tokenizeOnChars, (Object)this, "tokenizeOnChars");
        this.maxTokenLength = builder.maxTokenLength;
    }

    public static CharGroupTokenizer of(Function<Builder, ObjectBuilder<CharGroupTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.CharGroup;
    }

    public final List<String> tokenizeOnChars() {
        return this.tokenizeOnChars;
    }

    @Nullable
    public final Integer maxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "char_group");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.tokenizeOnChars)) {
            generator.writeKey("tokenize_on_chars");
            generator.writeStartArray();
            for (String item0 : this.tokenizeOnChars) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.maxTokenLength != null) {
            generator.writeKey("max_token_length");
            generator.write(this.maxTokenLength.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCharGroupTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::tokenizeOnChars, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tokenize_on_chars");
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CharGroupTokenizer> {
        private List<String> tokenizeOnChars;
        @Nullable
        private Integer maxTokenLength;

        public Builder() {
        }

        private Builder(CharGroupTokenizer instance) {
            this.tokenizeOnChars = instance.tokenizeOnChars;
            this.maxTokenLength = instance.maxTokenLength;
        }

        public final Builder tokenizeOnChars(List<String> list) {
            this.tokenizeOnChars = Builder._listAddAll(this.tokenizeOnChars, list);
            return this;
        }

        public final Builder tokenizeOnChars(String value, String ... values) {
            this.tokenizeOnChars = Builder._listAdd(this.tokenizeOnChars, value, values);
            return this;
        }

        public final Builder maxTokenLength(@Nullable Integer value) {
            this.maxTokenLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CharGroupTokenizer build() {
            this._checkSingleUse();
            return new CharGroupTokenizer(this);
        }
    }
}

