/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.NormalizeMethod;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NormalizeAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final NormalizeMethod method;
    public static final JsonpDeserializer<NormalizeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NormalizeAggregation::setupNormalizeAggregationDeserializer);

    private NormalizeAggregation(Builder builder) {
        super(builder);
        this.method = builder.method;
    }

    public static NormalizeAggregation of(Function<Builder, ObjectBuilder<NormalizeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Normalize;
    }

    @Nullable
    public final NormalizeMethod method() {
        return this.method;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNormalizeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::method, NormalizeMethod._DESERIALIZER, "method");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NormalizeAggregation> {
        @Nullable
        private NormalizeMethod method;

        public Builder() {
        }

        private Builder(NormalizeAggregation instance) {
            this.method = instance.method;
        }

        public final Builder method(@Nullable NormalizeMethod value) {
            this.method = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NormalizeAggregation build() {
            this._checkSingleUse();
            return new NormalizeAggregation(this);
        }
    }
}

