/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.ChangeType;
import co.elastic.clients.elasticsearch._types.aggregations.ChangeTypeVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NonStationary
implements ChangeTypeVariant,
JsonpSerializable {
    private final double pValue;
    private final double rValue;
    private final String trend;
    public static final JsonpDeserializer<NonStationary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NonStationary::setupNonStationaryDeserializer);

    private NonStationary(Builder builder) {
        this.pValue = ApiTypeHelper.requireNonNull(builder.pValue, (Object)this, "pValue", 0.0);
        this.rValue = ApiTypeHelper.requireNonNull(builder.rValue, (Object)this, "rValue", 0.0);
        this.trend = ApiTypeHelper.requireNonNull(builder.trend, this, "trend");
    }

    public static NonStationary of(Function<Builder, ObjectBuilder<NonStationary>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ChangeType.Kind _changeTypeKind() {
        return ChangeType.Kind.NonStationary;
    }

    public final double pValue() {
        return this.pValue;
    }

    public final double rValue() {
        return this.rValue;
    }

    public final String trend() {
        return this.trend;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("p_value");
        generator.write(this.pValue);
        generator.writeKey("r_value");
        generator.write(this.rValue);
        generator.writeKey("trend");
        generator.write(this.trend);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNonStationaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pValue, JsonpDeserializer.doubleDeserializer(), "p_value");
        op.add(Builder::rValue, JsonpDeserializer.doubleDeserializer(), "r_value");
        op.add(Builder::trend, JsonpDeserializer.stringDeserializer(), "trend");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NonStationary> {
        private Double pValue;
        private Double rValue;
        private String trend;

        public Builder() {
        }

        private Builder(NonStationary instance) {
            this.pValue = instance.pValue;
            this.rValue = instance.rValue;
            this.trend = instance.trend;
        }

        public final Builder pValue(double value) {
            this.pValue = value;
            return this;
        }

        public final Builder rValue(double value) {
            this.rValue = value;
            return this;
        }

        public final Builder trend(String value) {
            this.trend = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NonStationary build() {
            this._checkSingleUse();
            return new NonStationary(this);
        }
    }
}

