/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LongTermsBucket
extends TermsBucketBase {
    private final long key;
    @Nullable
    private final String keyAsString;
    public static final JsonpDeserializer<LongTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LongTermsBucket::setupLongTermsBucketDeserializer);

    private LongTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, (Object)this, "key", 0L);
        this.keyAsString = builder.keyAsString;
    }

    public static LongTermsBucket of(Function<Builder, ObjectBuilder<LongTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLongTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        TermsBucketBase.setupTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.longDeserializer(), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
    }

    public static class Builder
    extends TermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LongTermsBucket> {
        private Long key;
        @Nullable
        private String keyAsString;

        public Builder() {
        }

        private Builder(LongTermsBucket instance) {
            this.key = instance.key;
            this.keyAsString = instance.keyAsString;
        }

        public final Builder key(long value) {
            this.key = value;
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LongTermsBucket build() {
            this._checkSingleUse();
            return new LongTermsBucket(this);
        }
    }
}

