/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfigVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    private final String modelId;
    @Nullable
    private final InferenceConfig inferenceConfig;
    public static final JsonpDeserializer<InferenceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceAggregation::setupInferenceAggregationDeserializer);

    private InferenceAggregation(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.inferenceConfig = builder.inferenceConfig;
    }

    public static InferenceAggregation of(Function<Builder, ObjectBuilder<InferenceAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Inference;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupInferenceAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceAggregation> {
        private String modelId;
        @Nullable
        private InferenceConfig inferenceConfig;

        public Builder() {
        }

        private Builder(InferenceAggregation instance) {
            this.modelId = instance.modelId;
            this.inferenceConfig = instance.inferenceConfig;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder inferenceConfig(@Nullable InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public final Builder inferenceConfig(InferenceConfigVariant value) {
            this.inferenceConfig = value._toInferenceConfig();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceAggregation build() {
            this._checkSingleUse();
            return new InferenceAggregation(this);
        }
    }
}

