/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Retries
implements JsonpSerializable {
    private final long bulk;
    private final long search;
    public static final JsonpDeserializer<Retries> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retries::setupRetriesDeserializer);

    private Retries(Builder builder) {
        this.bulk = ApiTypeHelper.requireNonNull(builder.bulk, (Object)this, "bulk", 0L);
        this.search = ApiTypeHelper.requireNonNull(builder.search, (Object)this, "search", 0L);
    }

    public static Retries of(Function<Builder, ObjectBuilder<Retries>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bulk() {
        return this.bulk;
    }

    public final long search() {
        return this.search;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bulk");
        generator.write(this.bulk);
        generator.writeKey("search");
        generator.write(this.search);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRetriesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bulk, JsonpDeserializer.longDeserializer(), "bulk");
        op.add(Builder::search, JsonpDeserializer.longDeserializer(), "search");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Retries> {
        private Long bulk;
        private Long search;

        public Builder() {
        }

        private Builder(Retries instance) {
            this.bulk = instance.bulk;
            this.search = instance.search;
        }

        public final Builder bulk(long value) {
            this.bulk = value;
            return this;
        }

        public final Builder search(long value) {
            this.search = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Retries build() {
            this._checkSingleUse();
            return new Retries(this);
        }
    }
}

