/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.RRFRetrieverComponent;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RRFRetrieverEntry
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<RRFRetrieverEntry> _DESERIALIZER = JsonpDeserializer.lazy(RRFRetrieverEntry::buildRRFRetrieverEntryDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private RRFRetrieverEntry(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private RRFRetrieverEntry(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static RRFRetrieverEntry of(Function<Builder, ObjectBuilder<RRFRetrieverEntry>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isWeighted() {
        return this._kind == Kind.Weighted;
    }

    public RRFRetrieverComponent weighted() {
        return (RRFRetrieverComponent)TaggedUnionUtils.get(this, Kind.Weighted);
    }

    public boolean isRetriever() {
        return this._kind == Kind.Retriever;
    }

    public Retriever retriever() {
        return (Retriever)TaggedUnionUtils.get(this, Kind.Retriever);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<RRFRetrieverEntry> buildRRFRetrieverEntryDeserializer() {
        return new UnionDeserializer.Builder<RRFRetrieverEntry, Kind, Object>(RRFRetrieverEntry::new, false).addMember(Kind.Weighted, RRFRetrieverComponent._DESERIALIZER).addMember(Kind.Retriever, Retriever._DESERIALIZER).build();
    }

    public static enum Kind {
        Weighted,
        Retriever;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RRFRetrieverEntry> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<RRFRetrieverEntry> weighted(RRFRetrieverComponent v) {
            this._kind = Kind.Weighted;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RRFRetrieverEntry> weighted(Function<RRFRetrieverComponent.Builder, ObjectBuilder<RRFRetrieverComponent>> fn) {
            return this.weighted(fn.apply(new RRFRetrieverComponent.Builder()).build());
        }

        public ObjectBuilder<RRFRetrieverEntry> retriever(Retriever v) {
            this._kind = Kind.Retriever;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RRFRetrieverEntry> retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        @Override
        public RRFRetrieverEntry build() {
            this._checkSingleUse();
            return new RRFRetrieverEntry(this);
        }
    }
}

