/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LatLonGeoLocation
implements JsonpSerializable {
    private final double lat;
    private final double lon;
    public static final JsonpDeserializer<LatLonGeoLocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LatLonGeoLocation::setupLatLonGeoLocationDeserializer);

    private LatLonGeoLocation(Builder builder) {
        this.lat = ApiTypeHelper.requireNonNull(builder.lat, (Object)this, "lat", 0.0);
        this.lon = ApiTypeHelper.requireNonNull(builder.lon, (Object)this, "lon", 0.0);
    }

    public static LatLonGeoLocation of(Function<Builder, ObjectBuilder<LatLonGeoLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double lat() {
        return this.lat;
    }

    public final double lon() {
        return this.lon;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lat");
        generator.write(this.lat);
        generator.writeKey("lon");
        generator.write(this.lon);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLatLonGeoLocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lat, JsonpDeserializer.doubleDeserializer(), "lat");
        op.add(Builder::lon, JsonpDeserializer.doubleDeserializer(), "lon");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LatLonGeoLocation> {
        private Double lat;
        private Double lon;

        public Builder() {
        }

        private Builder(LatLonGeoLocation instance) {
            this.lat = instance.lat;
            this.lon = instance.lon;
        }

        public final Builder lat(double value) {
            this.lat = value;
            return this;
        }

        public final Builder lon(double value) {
            this.lon = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LatLonGeoLocation build() {
            this._checkSingleUse();
            return new LatLonGeoLocation(this);
        }
    }
}

