/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.bulk;

import co.elastic.clients.elasticsearch._helpers.bulk.RetryableBulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperationBase;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.BinaryData;
import java.util.List;
import javax.annotation.Nullable;

class IngesterOperation {
    private final RetryableBulkOperation repeatableOp;
    private final long size;

    IngesterOperation(RetryableBulkOperation repeatableOp, long size) {
        this.repeatableOp = repeatableOp;
        this.size = size;
    }

    public static IngesterOperation of(RetryableBulkOperation repeatableOp, JsonpMapper mapper) {
        switch (repeatableOp.operation()._kind()) {
            case Create: {
                return IngesterOperation.createOperation(repeatableOp, mapper);
            }
            case Index: {
                return IngesterOperation.indexOperation(repeatableOp, mapper);
            }
            case Update: {
                return IngesterOperation.updateOperation(repeatableOp, mapper);
            }
            case Delete: {
                return IngesterOperation.deleteOperation(repeatableOp);
            }
        }
        throw new IllegalStateException("Unknown bulk operation type " + String.valueOf(repeatableOp.operation()._kind()));
    }

    public RetryableBulkOperation repeatableOperation() {
        return this.repeatableOp;
    }

    public long size() {
        return this.size;
    }

    private static IngesterOperation createOperation(RetryableBulkOperation repeatableOp, JsonpMapper mapper) {
        RetryableBulkOperation newOperation;
        CreateOperation create = repeatableOp.operation().create();
        long size = IngesterOperation.basePropertiesSize(create);
        if (create.document() instanceof BinaryData) {
            newOperation = repeatableOp;
            size += ((BinaryData)create.document()).size();
        } else {
            BinaryData binaryDoc = BinaryData.of(create.document(), mapper);
            size += binaryDoc.size();
            newOperation = new RetryableBulkOperation(BulkOperation.of(bo -> bo.create(idx -> {
                IngesterOperation.copyCreateProperties(create, idx);
                return idx.document(binaryDoc);
            })), repeatableOp.context(), repeatableOp.retries());
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation indexOperation(RetryableBulkOperation repeatableOp, JsonpMapper mapper) {
        RetryableBulkOperation newOperation;
        IndexOperation index = repeatableOp.operation().index();
        long size = IngesterOperation.basePropertiesSize(index);
        if (index.document() instanceof BinaryData) {
            newOperation = repeatableOp;
            size += ((BinaryData)index.document()).size();
        } else {
            BinaryData binaryDoc = BinaryData.of(index.document(), mapper);
            size += binaryDoc.size();
            newOperation = new RetryableBulkOperation(BulkOperation.of(bo -> bo.index(idx -> {
                IngesterOperation.copyIndexProperties(index, idx);
                return idx.document(binaryDoc);
            })), repeatableOp.context(), repeatableOp.retries());
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation updateOperation(RetryableBulkOperation repeatableOp, JsonpMapper mapper) {
        RetryableBulkOperation newOperation;
        UpdateOperation update = repeatableOp.operation().update();
        long size = IngesterOperation.basePropertiesSize(update) + IngesterOperation.size("retry_on_conflict", update.retryOnConflict()) + IngesterOperation.size("require_alias", update.requireAlias());
        if (update.binaryAction() != null) {
            newOperation = repeatableOp;
            size += update.binaryAction().size();
        } else {
            BinaryData action = BinaryData.of(update.action(), mapper);
            size += action.size();
            newOperation = new RetryableBulkOperation(BulkOperation.of(bo -> bo.update(u -> {
                IngesterOperation.copyBaseProperties(update, u);
                return u.binaryAction(action).requireAlias(update.requireAlias()).retryOnConflict(update.retryOnConflict());
            })), repeatableOp.context(), repeatableOp.retries());
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation deleteOperation(RetryableBulkOperation repeatableOp) {
        DeleteOperation delete = repeatableOp.operation().delete();
        return new IngesterOperation(repeatableOp, IngesterOperation.basePropertiesSize(delete));
    }

    private static void copyBaseProperties(BulkOperationBase op, BulkOperationBase.AbstractBuilder<?> builder) {
        ((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)builder.id(op.id())).index(op.index())).ifPrimaryTerm(op.ifPrimaryTerm())).ifSeqNo(op.ifSeqNo())).routing(op.routing())).version(op.version())).versionType(op.versionType());
    }

    private static void copyIndexProperties(IndexOperation<?> op, IndexOperation.Builder<?> builder) {
        IngesterOperation.copyBaseProperties(op, builder);
        builder.pipeline(op.pipeline());
        builder.requireAlias(op.requireAlias());
    }

    private static void copyCreateProperties(CreateOperation<?> op, CreateOperation.Builder<?> builder) {
        IngesterOperation.copyBaseProperties(op, builder);
        builder.pipeline(op.pipeline());
        builder.requireAlias(op.requireAlias());
    }

    private static int size(String name, @Nullable Boolean value) {
        if (value != null) {
            return name.length() + 12;
        }
        return 0;
    }

    private static int size(String name, @Nullable String value) {
        if (value != null) {
            return name.length() + value.length() + 6;
        }
        return 0;
    }

    private static int size(String name, @Nullable Long value) {
        if (value != null) {
            int mag = 32 - Long.numberOfLeadingZeros(value);
            int chars = Math.max((mag + 2) / 3, 1);
            return name.length() + chars + 4;
        }
        return 0;
    }

    private static int size(String name, @Nullable Integer value) {
        if (value != null) {
            int mag = 32 - Integer.numberOfLeadingZeros(value);
            int chars = Math.max((mag + 2) / 3, 1);
            return name.length() + chars + 4;
        }
        return 0;
    }

    private static int size(String name, @Nullable JsonEnum value) {
        if (value != null) {
            return name.length() + value.jsonValue().length() + 6;
        }
        return 0;
    }

    private static int size(String name, @Nullable List<String> value) {
        if (value != null) {
            if (value.isEmpty()) {
                return name.length() + 6;
            }
            int listSize = 0;
            for (String item : value) {
                listSize += item.length();
                listSize += 2;
            }
            return name.length() + (listSize += value.size() - 1) + 6;
        }
        return 0;
    }

    private static int basePropertiesSize(BulkOperationBase op) {
        return IngesterOperation.size("id", op.id()) + IngesterOperation.size("index", op.index()) + IngesterOperation.size("if_primary_term", op.ifPrimaryTerm()) + IngesterOperation.size("if_seq_no", op.ifSeqNo()) + IngesterOperation.size("routing", op.routing()) + IngesterOperation.size("version", op.version()) + IngesterOperation.size("version_type", op.versionType()) + 4;
    }
}

