/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client;

import co.elastic.clients.transport.rest5_client.low_level.HttpAsyncResponseConsumerFactory;
import co.elastic.clients.transport.rest5_client.low_level.RequestOptions;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;

public class SafeResponseConsumer<T>
implements AsyncResponseConsumer<T> {
    private final AsyncResponseConsumer<T> delegate;
    public static final HttpAsyncResponseConsumerFactory DEFAULT_FACTORY = () -> new SafeResponseConsumer(RequestOptions.DEFAULT.getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer());
    public static final RequestOptions DEFAULT_REQUEST_OPTIONS = RequestOptions.DEFAULT.toBuilder().setHttpAsyncResponseConsumerFactory(DEFAULT_FACTORY).build();

    public SafeResponseConsumer(AsyncResponseConsumer<T> delegate) {
        this.delegate = delegate;
    }

    private static <T extends Throwable> void throwUnchecked(Throwable thr) throws T {
        throw thr;
    }

    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<T> resultCallback) {
        try {
            this.delegate.consumeResponse(response, entityDetails, context, resultCallback);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error consuming response", e);
        }
    }

    public void informationResponse(HttpResponse response, HttpContext context) {
        try {
            this.delegate.informationResponse(response, context);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error information response", e);
        }
    }

    public void failed(Exception cause) {
        try {
            this.delegate.failed(cause);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error handling failure", e);
        }
    }

    public void updateCapacity(CapacityChannel capacityChannel) {
        try {
            this.delegate.updateCapacity(capacityChannel);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error updating capacity", e);
        }
    }

    public void consume(ByteBuffer src) {
        try {
            this.delegate.consume(src);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error consuming data", e);
        }
    }

    public void streamEnd(List<? extends Header> trailers) {
        try {
            this.delegate.streamEnd(trailers);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error triggering stream end", e);
        }
    }

    public void releaseResources() {
        this.delegate.releaseResources();
    }
}

