/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateCrossClusterApiKeyResponse
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final Long expiration;
    private final String id;
    private final String name;
    private final String encoded;
    public static final JsonpDeserializer<CreateCrossClusterApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateCrossClusterApiKeyResponse::setupCreateCrossClusterApiKeyResponseDeserializer);

    private CreateCrossClusterApiKeyResponse(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.expiration = builder.expiration;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.encoded = ApiTypeHelper.requireNonNull(builder.encoded, this, "encoded");
    }

    public static CreateCrossClusterApiKeyResponse of(Function<Builder, ObjectBuilder<CreateCrossClusterApiKeyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final Long expiration() {
        return this.expiration;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String encoded() {
        return this.encoded;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration.longValue());
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("encoded");
        generator.write(this.encoded);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCreateCrossClusterApiKeyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::expiration, JsonpDeserializer.longDeserializer(), "expiration");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::encoded, JsonpDeserializer.stringDeserializer(), "encoded");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CreateCrossClusterApiKeyResponse> {
        private String apiKey;
        @Nullable
        private Long expiration;
        private String id;
        private String name;
        private String encoded;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder expiration(@Nullable Long value) {
            this.expiration = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder encoded(String value) {
            this.encoded = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateCrossClusterApiKeyResponse build() {
            this._checkSingleUse();
            return new CreateCrossClusterApiKeyResponse(this);
        }
    }
}

