/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PipelineProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String name;
    @Nullable
    private final Boolean ignoreMissingPipeline;
    public static final JsonpDeserializer<PipelineProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineProcessor::setupPipelineProcessorDeserializer);

    private PipelineProcessor(Builder builder) {
        super(builder);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.ignoreMissingPipeline = builder.ignoreMissingPipeline;
    }

    public static PipelineProcessor of(Function<Builder, ObjectBuilder<PipelineProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Pipeline;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Boolean ignoreMissingPipeline() {
        return this.ignoreMissingPipeline;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        if (this.ignoreMissingPipeline != null) {
            generator.writeKey("ignore_missing_pipeline");
            generator.write(this.ignoreMissingPipeline.booleanValue());
        }
    }

    protected static void setupPipelineProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::ignoreMissingPipeline, JsonpDeserializer.booleanDeserializer(), "ignore_missing_pipeline");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PipelineProcessor> {
        private String name;
        @Nullable
        private Boolean ignoreMissingPipeline;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder ignoreMissingPipeline(@Nullable Boolean value) {
            this.ignoreMissingPipeline = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PipelineProcessor build() {
            this._checkSingleUse();
            return new PipelineProcessor(this);
        }
    }
}

