/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.GoogleModelGardenProvider;
import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GoogleVertexAIServiceSettings
implements JsonpSerializable {
    @Nullable
    private final GoogleModelGardenProvider provider;
    @Nullable
    private final String url;
    @Nullable
    private final String streamingUrl;
    @Nullable
    private final String location;
    @Nullable
    private final String modelId;
    @Nullable
    private final String projectId;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String serviceAccountJson;
    @Nullable
    private final Integer dimensions;
    public static final JsonpDeserializer<GoogleVertexAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleVertexAIServiceSettings::setupGoogleVertexAIServiceSettingsDeserializer);

    private GoogleVertexAIServiceSettings(Builder builder) {
        this.provider = builder.provider;
        this.url = builder.url;
        this.streamingUrl = builder.streamingUrl;
        this.location = builder.location;
        this.modelId = builder.modelId;
        this.projectId = builder.projectId;
        this.rateLimit = builder.rateLimit;
        this.serviceAccountJson = ApiTypeHelper.requireNonNull(builder.serviceAccountJson, this, "serviceAccountJson");
        this.dimensions = builder.dimensions;
    }

    public static GoogleVertexAIServiceSettings of(Function<Builder, ObjectBuilder<GoogleVertexAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final GoogleModelGardenProvider provider() {
        return this.provider;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Nullable
    public final String streamingUrl() {
        return this.streamingUrl;
    }

    @Nullable
    public final String location() {
        return this.location;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String projectId() {
        return this.projectId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String serviceAccountJson() {
        return this.serviceAccountJson;
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.provider != null) {
            generator.writeKey("provider");
            this.provider.serialize(generator, mapper);
        }
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
        if (this.streamingUrl != null) {
            generator.writeKey("streaming_url");
            generator.write(this.streamingUrl);
        }
        if (this.location != null) {
            generator.writeKey("location");
            generator.write(this.location);
        }
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.projectId != null) {
            generator.writeKey("project_id");
            generator.write(this.projectId);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("service_account_json");
        generator.write(this.serviceAccountJson);
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGoogleVertexAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::provider, GoogleModelGardenProvider._DESERIALIZER, "provider");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::streamingUrl, JsonpDeserializer.stringDeserializer(), "streaming_url");
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::projectId, JsonpDeserializer.stringDeserializer(), "project_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::serviceAccountJson, JsonpDeserializer.stringDeserializer(), "service_account_json");
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GoogleVertexAIServiceSettings> {
        @Nullable
        private GoogleModelGardenProvider provider;
        @Nullable
        private String url;
        @Nullable
        private String streamingUrl;
        @Nullable
        private String location;
        @Nullable
        private String modelId;
        @Nullable
        private String projectId;
        @Nullable
        private RateLimitSetting rateLimit;
        private String serviceAccountJson;
        @Nullable
        private Integer dimensions;

        public final Builder provider(@Nullable GoogleModelGardenProvider value) {
            this.provider = value;
            return this;
        }

        public final Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        public final Builder streamingUrl(@Nullable String value) {
            this.streamingUrl = value;
            return this;
        }

        public final Builder location(@Nullable String value) {
            this.location = value;
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder projectId(@Nullable String value) {
            this.projectId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder serviceAccountJson(String value) {
            this.serviceAccountJson = value;
            return this;
        }

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GoogleVertexAIServiceSettings build() {
            this._checkSingleUse();
            return new GoogleVertexAIServiceSettings(this);
        }
    }
}

