/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterJvmMemory
implements JsonpSerializable {
    private final long heapMaxInBytes;
    @Nullable
    private final String heapMax;
    private final long heapUsedInBytes;
    @Nullable
    private final String heapUsed;
    public static final JsonpDeserializer<ClusterJvmMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmMemory::setupClusterJvmMemoryDeserializer);

    private ClusterJvmMemory(Builder builder) {
        this.heapMaxInBytes = ApiTypeHelper.requireNonNull(builder.heapMaxInBytes, (Object)this, "heapMaxInBytes", 0L);
        this.heapMax = builder.heapMax;
        this.heapUsedInBytes = ApiTypeHelper.requireNonNull(builder.heapUsedInBytes, (Object)this, "heapUsedInBytes", 0L);
        this.heapUsed = builder.heapUsed;
    }

    public static ClusterJvmMemory of(Function<Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    @Nullable
    public final String heapMax() {
        return this.heapMax;
    }

    public final long heapUsedInBytes() {
        return this.heapUsedInBytes;
    }

    @Nullable
    public final String heapUsed() {
        return this.heapUsed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("heap_max_in_bytes");
        generator.write(this.heapMaxInBytes);
        if (this.heapMax != null) {
            generator.writeKey("heap_max");
            generator.write(this.heapMax);
        }
        generator.writeKey("heap_used_in_bytes");
        generator.write(this.heapUsedInBytes);
        if (this.heapUsed != null) {
            generator.writeKey("heap_used");
            generator.write(this.heapUsed);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterJvmMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.longDeserializer(), "heap_max_in_bytes");
        op.add(Builder::heapMax, JsonpDeserializer.stringDeserializer(), "heap_max");
        op.add(Builder::heapUsedInBytes, JsonpDeserializer.longDeserializer(), "heap_used_in_bytes");
        op.add(Builder::heapUsed, JsonpDeserializer.stringDeserializer(), "heap_used");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterJvmMemory> {
        private Long heapMaxInBytes;
        @Nullable
        private String heapMax;
        private Long heapUsedInBytes;
        @Nullable
        private String heapUsed;

        public final Builder heapMaxInBytes(long value) {
            this.heapMaxInBytes = value;
            return this;
        }

        public final Builder heapMax(@Nullable String value) {
            this.heapMax = value;
            return this;
        }

        public final Builder heapUsedInBytes(long value) {
            this.heapUsedInBytes = value;
            return this;
        }

        public final Builder heapUsed(@Nullable String value) {
            this.heapUsed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterJvmMemory build() {
            this._checkSingleUse();
            return new ClusterJvmMemory(this);
        }
    }
}

