/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class RangePropertyBase
extends DocValuesPropertyBase {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean index;

    protected RangePropertyBase(AbstractBuilder<?> builder) {
        super((DocValuesPropertyBase.AbstractBuilder<?>)builder);
        this.boost = builder.boost;
        this.coerce = builder.coerce;
        this.index = builder.index;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupRangePropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(AbstractBuilder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(AbstractBuilder::index, JsonpDeserializer.booleanDeserializer(), "index");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends DocValuesPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean index;

        public final BuilderT boost(@Nullable Double value) {
            this.boost = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT coerce(@Nullable Boolean value) {
            this.coerce = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT index(@Nullable Boolean value) {
            this.index = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

