/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PValueHeuristic
implements JsonpSerializable {
    @Nullable
    private final Boolean backgroundIsSuperset;
    @Nullable
    private final Long normalizeAbove;
    public static final JsonpDeserializer<PValueHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PValueHeuristic::setupPValueHeuristicDeserializer);

    private PValueHeuristic(Builder builder) {
        this.backgroundIsSuperset = builder.backgroundIsSuperset;
        this.normalizeAbove = builder.normalizeAbove;
    }

    public static PValueHeuristic of(Function<Builder, ObjectBuilder<PValueHeuristic>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    @Nullable
    public final Long normalizeAbove() {
        return this.normalizeAbove;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.backgroundIsSuperset != null) {
            generator.writeKey("background_is_superset");
            generator.write(this.backgroundIsSuperset.booleanValue());
        }
        if (this.normalizeAbove != null) {
            generator.writeKey("normalize_above");
            generator.write(this.normalizeAbove.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPValueHeuristicDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset");
        op.add(Builder::normalizeAbove, JsonpDeserializer.longDeserializer(), "normalize_above");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PValueHeuristic> {
        @Nullable
        private Boolean backgroundIsSuperset;
        @Nullable
        private Long normalizeAbove;

        public final Builder backgroundIsSuperset(@Nullable Boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        public final Builder normalizeAbove(@Nullable Long value) {
            this.normalizeAbove = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PValueHeuristic build() {
            this._checkSingleUse();
            return new PValueHeuristic(this);
        }
    }
}

