/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.SamplerAggregationExecutionHint;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DiversifiedSamplerAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final SamplerAggregationExecutionHint executionHint;
    @Nullable
    private final Integer maxDocsPerValue;
    @Nullable
    private final Script script;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final String field;
    public static final JsonpDeserializer<DiversifiedSamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiversifiedSamplerAggregation::setupDiversifiedSamplerAggregationDeserializer);

    private DiversifiedSamplerAggregation(Builder builder) {
        this.executionHint = builder.executionHint;
        this.maxDocsPerValue = builder.maxDocsPerValue;
        this.script = builder.script;
        this.shardSize = builder.shardSize;
        this.field = builder.field;
    }

    public static DiversifiedSamplerAggregation of(Function<Builder, ObjectBuilder<DiversifiedSamplerAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.DiversifiedSampler;
    }

    @Nullable
    public final SamplerAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final Integer maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.maxDocsPerValue != null) {
            generator.writeKey("max_docs_per_value");
            generator.write(this.maxDocsPerValue.intValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDiversifiedSamplerAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::executionHint, SamplerAggregationExecutionHint._DESERIALIZER, "execution_hint");
        op.add(Builder::maxDocsPerValue, JsonpDeserializer.integerDeserializer(), "max_docs_per_value");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DiversifiedSamplerAggregation> {
        @Nullable
        private SamplerAggregationExecutionHint executionHint;
        @Nullable
        private Integer maxDocsPerValue;
        @Nullable
        private Script script;
        @Nullable
        private Integer shardSize;
        @Nullable
        private String field;

        public final Builder executionHint(@Nullable SamplerAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        public final Builder maxDocsPerValue(@Nullable Integer value) {
            this.maxDocsPerValue = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiversifiedSamplerAggregation build() {
            this._checkSingleUse();
            return new DiversifiedSamplerAggregation(this);
        }
    }
}

