/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Ipinfo;
import co.elastic.clients.elasticsearch.ingest.Local;
import co.elastic.clients.elasticsearch.ingest.Maxmind;
import co.elastic.clients.elasticsearch.ingest.Web;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatabaseConfigurationFull
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final String name;
    public static final JsonpDeserializer<DatabaseConfigurationFull> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatabaseConfigurationFull::setupDatabaseConfigurationFullDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private DatabaseConfigurationFull(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static DatabaseConfigurationFull of(Function<Builder, ObjectBuilder<DatabaseConfigurationFull>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public boolean isWeb() {
        return this._kind == Kind.Web;
    }

    public Web web() {
        return (Web)TaggedUnionUtils.get(this, Kind.Web);
    }

    public boolean isLocal() {
        return this._kind == Kind.Local;
    }

    public Local local() {
        return (Local)TaggedUnionUtils.get(this, Kind.Local);
    }

    public boolean isMaxmind() {
        return this._kind == Kind.Maxmind;
    }

    public Maxmind maxmind() {
        return (Maxmind)TaggedUnionUtils.get(this, Kind.Maxmind);
    }

    public boolean isIpinfo() {
        return this._kind == Kind.Ipinfo;
    }

    public Ipinfo ipinfo() {
        return (Ipinfo)TaggedUnionUtils.get(this, Kind.Ipinfo);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDatabaseConfigurationFullDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::web, Web._DESERIALIZER, "web");
        op.add(Builder::local, Local._DESERIALIZER, "local");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::maxmind, Maxmind._DESERIALIZER, "maxmind");
        op.add(Builder::ipinfo, Ipinfo._DESERIALIZER, "ipinfo");
    }

    public static enum Kind implements JsonEnum
    {
        Web("web"),
        Local("local"),
        Maxmind("maxmind"),
        Ipinfo("ipinfo");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatabaseConfigurationFull> {
        private Kind _kind;
        private Object _value;
        private String name;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder web(Web v) {
            this._kind = Kind.Web;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder web(Function<Web.Builder, ObjectBuilder<Web>> fn) {
            return this.web(fn.apply(new Web.Builder()).build());
        }

        public ContainerBuilder local(Local v) {
            this._kind = Kind.Local;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder local(Function<Local.Builder, ObjectBuilder<Local>> fn) {
            return this.local(fn.apply(new Local.Builder()).build());
        }

        public ContainerBuilder maxmind(Maxmind v) {
            this._kind = Kind.Maxmind;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder maxmind(Function<Maxmind.Builder, ObjectBuilder<Maxmind>> fn) {
            return this.maxmind(fn.apply(new Maxmind.Builder()).build());
        }

        public ContainerBuilder ipinfo(Ipinfo v) {
            this._kind = Kind.Ipinfo;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder ipinfo(Function<Ipinfo.Builder, ObjectBuilder<Ipinfo>> fn) {
            return this.ipinfo(fn.apply(new Ipinfo.Builder()).build());
        }

        @Override
        public DatabaseConfigurationFull build() {
            this._checkSingleUse();
            return new DatabaseConfigurationFull(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<DatabaseConfigurationFull> {
            public final ContainerBuilder name(String value) {
                Builder.this.name = value;
                return this;
            }

            @Override
            public DatabaseConfigurationFull build() {
                return Builder.this.build();
            }
        }
    }
}

