/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.ScoreNormalizer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InnerRetriever
implements JsonpSerializable {
    private final Retriever retriever;
    private final float weight;
    private final ScoreNormalizer normalizer;
    public static final JsonpDeserializer<InnerRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InnerRetriever::setupInnerRetrieverDeserializer);

    private InnerRetriever(Builder builder) {
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.weight = ApiTypeHelper.requireNonNull(builder.weight, (Object)this, "weight", 0.0f);
        this.normalizer = ApiTypeHelper.requireNonNull(builder.normalizer, this, "normalizer");
    }

    public static InnerRetriever of(Function<Builder, ObjectBuilder<InnerRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    public final float weight() {
        return this.weight;
    }

    public final ScoreNormalizer normalizer() {
        return this.normalizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        generator.writeKey("weight");
        generator.write((double)this.weight);
        generator.writeKey("normalizer");
        this.normalizer.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInnerRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::weight, JsonpDeserializer.floatDeserializer(), "weight");
        op.add(Builder::normalizer, ScoreNormalizer._DESERIALIZER, "normalizer");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InnerRetriever> {
        private Retriever retriever;
        private Float weight;
        private ScoreNormalizer normalizer;

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder weight(float value) {
            this.weight = Float.valueOf(value);
            return this;
        }

        public final Builder normalizer(ScoreNormalizer value) {
            this.normalizer = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InnerRetriever build() {
            this._checkSingleUse();
            return new InnerRetriever(this);
        }
    }
}

