/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.elasticsearch.indices.IndexMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ResolveIndexItem
implements JsonpSerializable {
    private final String name;
    private final List<String> aliases;
    private final List<String> attributes;
    @Nullable
    private final String dataStream;
    @Nullable
    private final IndexMode mode;
    public static final JsonpDeserializer<ResolveIndexItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexItem::setupResolveIndexItemDeserializer);

    private ResolveIndexItem(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.dataStream = builder.dataStream;
        this.mode = builder.mode;
    }

    public static ResolveIndexItem of(Function<Builder, ObjectBuilder<ResolveIndexItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<String> aliases() {
        return this.aliases;
    }

    public final List<String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String dataStream() {
        return this.dataStream;
    }

    @Nullable
    public final IndexMode mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartArray();
            for (String item0 : this.attributes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            generator.write(this.dataStream);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupResolveIndexItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::mode, IndexMode._DESERIALIZER, "mode");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResolveIndexItem> {
        private String name;
        @Nullable
        private List<String> aliases;
        private List<String> attributes;
        @Nullable
        private String dataStream;
        @Nullable
        private IndexMode mode;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        public final Builder attributes(List<String> list) {
            this.attributes = Builder._listAddAll(this.attributes, list);
            return this;
        }

        public final Builder attributes(String value, String ... values) {
            this.attributes = Builder._listAdd(this.attributes, value, values);
            return this;
        }

        public final Builder dataStream(@Nullable String value) {
            this.dataStream = value;
            return this;
        }

        public final Builder mode(@Nullable IndexMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveIndexItem build() {
            this._checkSingleUse();
            return new ResolveIndexItem(this);
        }
    }
}

