/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.modify_data_stream;

import co.elastic.clients.elasticsearch.indices.modify_data_stream.ActionVariant;
import co.elastic.clients.elasticsearch.indices.modify_data_stream.IndexAndDataStreamAction;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Action
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Action> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Action::setupActionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Action(ActionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._actionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Action(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Action of(Function<Builder, ObjectBuilder<Action>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAddBackingIndex() {
        return this._kind == Kind.AddBackingIndex;
    }

    public IndexAndDataStreamAction addBackingIndex() {
        return (IndexAndDataStreamAction)TaggedUnionUtils.get(this, Kind.AddBackingIndex);
    }

    public boolean isRemoveBackingIndex() {
        return this._kind == Kind.RemoveBackingIndex;
    }

    public IndexAndDataStreamAction removeBackingIndex() {
        return (IndexAndDataStreamAction)TaggedUnionUtils.get(this, Kind.RemoveBackingIndex);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::addBackingIndex, IndexAndDataStreamAction._DESERIALIZER, "add_backing_index");
        op.add(Builder::removeBackingIndex, IndexAndDataStreamAction._DESERIALIZER, "remove_backing_index");
    }

    public static enum Kind implements JsonEnum
    {
        AddBackingIndex("add_backing_index"),
        RemoveBackingIndex("remove_backing_index");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Action> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Action> addBackingIndex(IndexAndDataStreamAction v) {
            this._kind = Kind.AddBackingIndex;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Action> addBackingIndex(Function<IndexAndDataStreamAction.Builder, ObjectBuilder<IndexAndDataStreamAction>> fn) {
            return this.addBackingIndex(fn.apply(new IndexAndDataStreamAction.Builder()).build());
        }

        public ObjectBuilder<Action> removeBackingIndex(IndexAndDataStreamAction v) {
            this._kind = Kind.RemoveBackingIndex;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Action> removeBackingIndex(Function<IndexAndDataStreamAction.Builder, ObjectBuilder<IndexAndDataStreamAction>> fn) {
            return this.removeBackingIndex(fn.apply(new IndexAndDataStreamAction.Builder()).build());
        }

        @Override
        public Action build() {
            this._checkSingleUse();
            return new Action(this);
        }
    }
}

