/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RerouteParameters
implements JsonpSerializable {
    private final boolean allowPrimary;
    private final String index;
    private final String node;
    private final int shard;
    @Nullable
    private final String fromNode;
    @Nullable
    private final String toNode;
    public static final JsonpDeserializer<RerouteParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteParameters::setupRerouteParametersDeserializer);

    private RerouteParameters(Builder builder) {
        this.allowPrimary = ApiTypeHelper.requireNonNull(builder.allowPrimary, (Object)this, "allowPrimary", false);
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, (Object)this, "shard", 0);
        this.fromNode = builder.fromNode;
        this.toNode = builder.toNode;
    }

    public static RerouteParameters of(Function<Builder, ObjectBuilder<RerouteParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean allowPrimary() {
        return this.allowPrimary;
    }

    public final String index() {
        return this.index;
    }

    public final String node() {
        return this.node;
    }

    public final int shard() {
        return this.shard;
    }

    @Nullable
    public final String fromNode() {
        return this.fromNode;
    }

    @Nullable
    public final String toNode() {
        return this.toNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_primary");
        generator.write(this.allowPrimary);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.fromNode != null) {
            generator.writeKey("from_node");
            generator.write(this.fromNode);
        }
        if (this.toNode != null) {
            generator.writeKey("to_node");
            generator.write(this.toNode);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRerouteParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowPrimary, JsonpDeserializer.booleanDeserializer(), "allow_primary");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::fromNode, JsonpDeserializer.stringDeserializer(), "from_node");
        op.add(Builder::toNode, JsonpDeserializer.stringDeserializer(), "to_node");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RerouteParameters> {
        private Boolean allowPrimary;
        private String index;
        private String node;
        private Integer shard;
        @Nullable
        private String fromNode;
        @Nullable
        private String toNode;

        public final Builder allowPrimary(boolean value) {
            this.allowPrimary = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder fromNode(@Nullable String value) {
            this.fromNode = value;
            return this;
        }

        public final Builder toNode(@Nullable String value) {
            this.toNode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RerouteParameters build() {
            this._checkSingleUse();
            return new RerouteParameters(this);
        }
    }
}

