/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CommandCancelAction
implements JsonpSerializable {
    private final String index;
    private final int shard;
    private final String node;
    @Nullable
    private final Boolean allowPrimary;
    public static final JsonpDeserializer<CommandCancelAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommandCancelAction::setupCommandCancelActionDeserializer);

    private CommandCancelAction(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, (Object)this, "shard", 0);
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.allowPrimary = builder.allowPrimary;
    }

    public static CommandCancelAction of(Function<Builder, ObjectBuilder<CommandCancelAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final int shard() {
        return this.shard;
    }

    public final String node() {
        return this.node;
    }

    @Nullable
    public final Boolean allowPrimary() {
        return this.allowPrimary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("shard");
        generator.write(this.shard);
        generator.writeKey("node");
        generator.write(this.node);
        if (this.allowPrimary != null) {
            generator.writeKey("allow_primary");
            generator.write(this.allowPrimary.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCommandCancelActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::allowPrimary, JsonpDeserializer.booleanDeserializer(), "allow_primary");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CommandCancelAction> {
        private String index;
        private Integer shard;
        private String node;
        @Nullable
        private Boolean allowPrimary;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder allowPrimary(@Nullable Boolean value) {
            this.allowPrimary = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CommandCancelAction build() {
            this._checkSingleUse();
            return new CommandCancelAction(this);
        }
    }
}

