/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DecayPlacement;
import co.elastic.clients.elasticsearch._types.query_dsl.MultiValueMode;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class DecayFunctionBase<TOrigin, TScale>
implements JsonpSerializable {
    private final String field;
    private final DecayPlacement<TOrigin, TScale> placement;
    @Nullable
    private final MultiValueMode multiValueMode;
    @Nullable
    private final JsonpSerializer<TOrigin> tOriginSerializer;
    @Nullable
    private final JsonpSerializer<TScale> tScaleSerializer;

    protected DecayFunctionBase(AbstractBuilder<TOrigin, TScale, ?> builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.placement = ApiTypeHelper.requireNonNull(builder.placement, this, "placement");
        this.multiValueMode = builder.multiValueMode;
        this.tOriginSerializer = builder.tOriginSerializer;
        this.tScaleSerializer = builder.tScaleSerializer;
    }

    public final String field() {
        return this.field;
    }

    public final DecayPlacement<TOrigin, TScale> placement() {
        return this.placement;
    }

    @Nullable
    public final MultiValueMode multiValueMode() {
        return this.multiValueMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.placement.serialize(generator, mapper);
        if (this.multiValueMode != null) {
            generator.writeKey("multi_value_mode");
            this.multiValueMode.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <TOrigin, TScale, BuilderT extends AbstractBuilder<TOrigin, TScale, BuilderT>> void setupDecayFunctionBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TOrigin> tOriginDeserializer, JsonpDeserializer<TScale> tScaleDeserializer) {
        op.add(AbstractBuilder::multiValueMode, MultiValueMode._DESERIALIZER, "multi_value_mode");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.placement(DecayPlacement.createDecayPlacementDeserializer(tOriginDeserializer, tScaleDeserializer).deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static abstract class AbstractBuilder<TOrigin, TScale, BuilderT extends AbstractBuilder<TOrigin, TScale, BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String field;
        private DecayPlacement<TOrigin, TScale> placement;
        @Nullable
        private MultiValueMode multiValueMode;
        @Nullable
        private JsonpSerializer<TOrigin> tOriginSerializer;
        @Nullable
        private JsonpSerializer<TScale> tScaleSerializer;

        public final BuilderT field(String value) {
            this.field = value;
            return (BuilderT)this.self();
        }

        public final BuilderT placement(DecayPlacement<TOrigin, TScale> value) {
            this.placement = value;
            return (BuilderT)this.self();
        }

        public final BuilderT placement(Function<DecayPlacement.Builder<TOrigin, TScale>, ObjectBuilder<DecayPlacement<TOrigin, TScale>>> fn) {
            return this.placement(fn.apply(new DecayPlacement.Builder()).build());
        }

        public final BuilderT multiValueMode(@Nullable MultiValueMode value) {
            this.multiValueMode = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tOriginSerializer(@Nullable JsonpSerializer<TOrigin> value) {
            this.tOriginSerializer = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tScaleSerializer(@Nullable JsonpSerializer<TScale> value) {
            this.tScaleSerializer = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

