/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.AzureRepositorySettings;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AzureRepository
extends RepositoryBase
implements RepositoryVariant {
    @Nullable
    private final AzureRepositorySettings settings;
    public static final JsonpDeserializer<AzureRepository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AzureRepository::setupAzureRepositoryDeserializer);

    private AzureRepository(Builder builder) {
        super(builder);
        this.settings = builder.settings;
    }

    public static AzureRepository of(Function<Builder, ObjectBuilder<AzureRepository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.Azure;
    }

    @Nullable
    public final AzureRepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "azure");
        super.serializeInternal(generator, mapper);
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
    }

    protected static void setupAzureRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, AzureRepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AzureRepository> {
        @Nullable
        private AzureRepositorySettings settings;

        public final Builder settings(@Nullable AzureRepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<AzureRepositorySettings.Builder, ObjectBuilder<AzureRepositorySettings>> fn) {
            return this.settings(fn.apply(new AzureRepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AzureRepository build() {
            this._checkSingleUse();
            return new AzureRepository(this);
        }
    }
}

