/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.GreaterThanValidation;
import co.elastic.clients.elasticsearch.connector.IncludedInValidation;
import co.elastic.clients.elasticsearch.connector.LessThanValidation;
import co.elastic.clients.elasticsearch.connector.ListTypeValidation;
import co.elastic.clients.elasticsearch.connector.RegexValidation;
import co.elastic.clients.elasticsearch.connector.ValidationVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Validation
implements TaggedUnion<Kind, ValidationVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final ValidationVariant _value;
    public static final JsonpDeserializer<Validation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Validation::setupValidationDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final ValidationVariant _get() {
        return this._value;
    }

    public Validation(ValidationVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._validationKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Validation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Validation of(Function<Builder, ObjectBuilder<Validation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isGreaterThan() {
        return this._kind == Kind.GreaterThan;
    }

    public GreaterThanValidation greaterThan() {
        return (GreaterThanValidation)TaggedUnionUtils.get(this, Kind.GreaterThan);
    }

    public boolean isIncludedIn() {
        return this._kind == Kind.IncludedIn;
    }

    public IncludedInValidation includedIn() {
        return (IncludedInValidation)TaggedUnionUtils.get(this, Kind.IncludedIn);
    }

    public boolean isLessThan() {
        return this._kind == Kind.LessThan;
    }

    public LessThanValidation lessThan() {
        return (LessThanValidation)TaggedUnionUtils.get(this, Kind.LessThan);
    }

    public boolean isListType() {
        return this._kind == Kind.ListType;
    }

    public ListTypeValidation listType() {
        return (ListTypeValidation)TaggedUnionUtils.get(this, Kind.ListType);
    }

    public boolean isRegex() {
        return this._kind == Kind.Regex;
    }

    public RegexValidation regex() {
        return (RegexValidation)TaggedUnionUtils.get(this, Kind.Regex);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::greaterThan, GreaterThanValidation._DESERIALIZER, "greater_than");
        op.add(Builder::includedIn, IncludedInValidation._DESERIALIZER, "included_in");
        op.add(Builder::lessThan, LessThanValidation._DESERIALIZER, "less_than");
        op.add(Builder::listType, ListTypeValidation._DESERIALIZER, "list_type");
        op.add(Builder::regex, RegexValidation._DESERIALIZER, "regex");
        op.setTypeProperty("type", null);
    }

    public static enum Kind implements JsonEnum
    {
        GreaterThan("greater_than"),
        IncludedIn("included_in"),
        LessThan("less_than"),
        ListType("list_type"),
        Regex("regex");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Validation> {
        private Kind _kind;
        private ValidationVariant _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Validation> greaterThan(GreaterThanValidation v) {
            this._kind = Kind.GreaterThan;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Validation> greaterThan(Function<GreaterThanValidation.Builder, ObjectBuilder<GreaterThanValidation>> fn) {
            return this.greaterThan(fn.apply(new GreaterThanValidation.Builder()).build());
        }

        public ObjectBuilder<Validation> includedIn(IncludedInValidation v) {
            this._kind = Kind.IncludedIn;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Validation> includedIn(Function<IncludedInValidation.Builder, ObjectBuilder<IncludedInValidation>> fn) {
            return this.includedIn(fn.apply(new IncludedInValidation.Builder()).build());
        }

        public ObjectBuilder<Validation> lessThan(LessThanValidation v) {
            this._kind = Kind.LessThan;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Validation> lessThan(Function<LessThanValidation.Builder, ObjectBuilder<LessThanValidation>> fn) {
            return this.lessThan(fn.apply(new LessThanValidation.Builder()).build());
        }

        public ObjectBuilder<Validation> listType(ListTypeValidation v) {
            this._kind = Kind.ListType;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Validation> listType(Function<ListTypeValidation.Builder, ObjectBuilder<ListTypeValidation>> fn) {
            return this.listType(fn.apply(new ListTypeValidation.Builder()).build());
        }

        public ObjectBuilder<Validation> regex(RegexValidation v) {
            this._kind = Kind.Regex;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Validation> regex(Function<RegexValidation.Builder, ObjectBuilder<RegexValidation>> fn) {
            return this.regex(fn.apply(new RegexValidation.Builder()).build());
        }

        @Override
        public Validation build() {
            this._checkSingleUse();
            return new Validation(this);
        }
    }
}

