/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch.tasks.ParentTaskInfo;
import co.elastic.clients.elasticsearch.tasks.TaskInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TaskInfos
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TaskInfos> _DESERIALIZER = JsonpDeserializer.lazy(TaskInfos::buildTaskInfosDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TaskInfos(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private TaskInfos(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TaskInfos of(Function<Builder, ObjectBuilder<TaskInfos>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFlat() {
        return this._kind == Kind.Flat;
    }

    public List<TaskInfo> flat() {
        return (List)TaggedUnionUtils.get(this, Kind.Flat);
    }

    public boolean isGrouped() {
        return this._kind == Kind.Grouped;
    }

    public Map<String, ParentTaskInfo> grouped() {
        return (Map)TaggedUnionUtils.get(this, Kind.Grouped);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Flat: {
                    generator.writeStartArray();
                    for (TaskInfo item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Grouped: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        ((ParentTaskInfo)item0.getValue()).serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<TaskInfos> buildTaskInfosDeserializer() {
        return new UnionDeserializer.Builder<TaskInfos, Kind, Object>(TaskInfos::new, false).addMember(Kind.Flat, JsonpDeserializer.arrayDeserializer(TaskInfo._DESERIALIZER)).addMember(Kind.Grouped, JsonpDeserializer.stringMapDeserializer(ParentTaskInfo._DESERIALIZER)).build();
    }

    public static enum Kind {
        Flat,
        Grouped;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TaskInfos> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<TaskInfos> flat(List<TaskInfo> v) {
            this._kind = Kind.Flat;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TaskInfos> grouped(Map<String, ParentTaskInfo> v) {
            this._kind = Kind.Grouped;
            this._value = v;
            return this;
        }

        @Override
        public TaskInfos build() {
            this._checkSingleUse();
            return new TaskInfos(this);
        }
    }
}

