/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.UserProfile;
import co.elastic.clients.elasticsearch.security.UserProfileHitMetadata;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class UserProfileWithMetadata
extends UserProfile {
    private final long lastSynchronized;
    private final UserProfileHitMetadata doc;
    public static final JsonpDeserializer<UserProfileWithMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserProfileWithMetadata::setupUserProfileWithMetadataDeserializer);

    protected UserProfileWithMetadata(AbstractBuilder<?> builder) {
        super(builder);
        this.lastSynchronized = ApiTypeHelper.requireNonNull(builder.lastSynchronized, (Object)this, "lastSynchronized", 0L);
        this.doc = ApiTypeHelper.requireNonNull(builder.doc, this, "doc");
    }

    public static UserProfileWithMetadata userProfileWithMetadataOf(Function<Builder, ObjectBuilder<UserProfileWithMetadata>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long lastSynchronized() {
        return this.lastSynchronized;
    }

    public final UserProfileHitMetadata doc() {
        return this.doc;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("last_synchronized");
        generator.write(this.lastSynchronized);
        generator.writeKey("_doc");
        this.doc.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupUserProfileWithMetadataDeserializer(ObjectDeserializer<BuilderT> op) {
        UserProfile.setupUserProfileDeserializer(op);
        op.add(AbstractBuilder::lastSynchronized, JsonpDeserializer.longDeserializer(), "last_synchronized");
        op.add(AbstractBuilder::doc, UserProfileHitMetadata._DESERIALIZER, "_doc");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends UserProfile.AbstractBuilder<BuilderT> {
        private Long lastSynchronized;
        private UserProfileHitMetadata doc;

        public final BuilderT lastSynchronized(long value) {
            this.lastSynchronized = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT doc(UserProfileHitMetadata value) {
            this.doc = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT doc(Function<UserProfileHitMetadata.Builder, ObjectBuilder<UserProfileHitMetadata>> fn) {
            return this.doc(fn.apply(new UserProfileHitMetadata.Builder()).build());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<UserProfileWithMetadata> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserProfileWithMetadata build() {
            this._checkSingleUse();
            return new UserProfileWithMetadata(this);
        }
    }
}

