/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.AnthropicServiceSettings;
import co.elastic.clients.elasticsearch.inference.AnthropicServiceType;
import co.elastic.clients.elasticsearch.inference.AnthropicTaskSettings;
import co.elastic.clients.elasticsearch.inference.AnthropicTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAnthropicResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAnthropicRequest
extends RequestBase
implements JsonpSerializable {
    private final String anthropicInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AnthropicServiceType service;
    private final AnthropicServiceSettings serviceSettings;
    @Nullable
    private final AnthropicTaskSettings taskSettings;
    private final AnthropicTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAnthropicRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAnthropicRequest::setupPutAnthropicRequestDeserializer);
    public static final Endpoint<PutAnthropicRequest, PutAnthropicResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAnthropicRequest, PutAnthropicResponse>("es/inference.put_anthropic", request -> "PUT", request -> {
        boolean _taskType = true;
        int _anthropicInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.anthropicInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _anthropicInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("anthropicInferenceId", request.anthropicInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAnthropicResponse._DESERIALIZER);

    private PutAnthropicRequest(Builder builder) {
        this.anthropicInferenceId = ApiTypeHelper.requireNonNull(builder.anthropicInferenceId, this, "anthropicInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAnthropicRequest of(Function<Builder, ObjectBuilder<PutAnthropicRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String anthropicInferenceId() {
        return this.anthropicInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AnthropicServiceType service() {
        return this.service;
    }

    public final AnthropicServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AnthropicTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final AnthropicTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutAnthropicRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AnthropicServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AnthropicServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AnthropicTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAnthropicRequest> {
        private String anthropicInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AnthropicServiceType service;
        private AnthropicServiceSettings serviceSettings;
        @Nullable
        private AnthropicTaskSettings taskSettings;
        private AnthropicTaskType taskType;
        @Nullable
        private Time timeout;

        public final Builder anthropicInferenceId(String value) {
            this.anthropicInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AnthropicServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AnthropicServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AnthropicServiceSettings.Builder, ObjectBuilder<AnthropicServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AnthropicServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AnthropicTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AnthropicTaskSettings.Builder, ObjectBuilder<AnthropicTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AnthropicTaskSettings.Builder()).build());
        }

        public final Builder taskType(AnthropicTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAnthropicRequest build() {
            this._checkSingleUse();
            return new PutAnthropicRequest(this);
        }
    }
}

