/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ClassificationInferenceOptions;
import co.elastic.clients.elasticsearch.ml.FillMaskInferenceOptions;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.LearningToRankConfig;
import co.elastic.clients.elasticsearch.ml.NerInferenceOptions;
import co.elastic.clients.elasticsearch.ml.PassThroughInferenceOptions;
import co.elastic.clients.elasticsearch.ml.QuestionAnsweringInferenceOptions;
import co.elastic.clients.elasticsearch.ml.RegressionInferenceOptions;
import co.elastic.clients.elasticsearch.ml.TextClassificationInferenceOptions;
import co.elastic.clients.elasticsearch.ml.TextEmbeddingInferenceOptions;
import co.elastic.clients.elasticsearch.ml.TextExpansionInferenceOptions;
import co.elastic.clients.elasticsearch.ml.ZeroShotClassificationInferenceOptions;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceConfigCreate
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<InferenceConfigCreate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfigCreate::setupInferenceConfigCreateDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public InferenceConfigCreate(InferenceConfigCreateVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._inferenceConfigCreateKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private InferenceConfigCreate(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static InferenceConfigCreate of(Function<Builder, ObjectBuilder<InferenceConfigCreate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isRegression() {
        return this._kind == Kind.Regression;
    }

    public RegressionInferenceOptions regression() {
        return (RegressionInferenceOptions)TaggedUnionUtils.get(this, Kind.Regression);
    }

    public boolean isClassification() {
        return this._kind == Kind.Classification;
    }

    public ClassificationInferenceOptions classification() {
        return (ClassificationInferenceOptions)TaggedUnionUtils.get(this, Kind.Classification);
    }

    public boolean isTextClassification() {
        return this._kind == Kind.TextClassification;
    }

    public TextClassificationInferenceOptions textClassification() {
        return (TextClassificationInferenceOptions)TaggedUnionUtils.get(this, Kind.TextClassification);
    }

    public boolean isZeroShotClassification() {
        return this._kind == Kind.ZeroShotClassification;
    }

    public ZeroShotClassificationInferenceOptions zeroShotClassification() {
        return (ZeroShotClassificationInferenceOptions)TaggedUnionUtils.get(this, Kind.ZeroShotClassification);
    }

    public boolean isFillMask() {
        return this._kind == Kind.FillMask;
    }

    public FillMaskInferenceOptions fillMask() {
        return (FillMaskInferenceOptions)TaggedUnionUtils.get(this, Kind.FillMask);
    }

    public boolean isLearningToRank() {
        return this._kind == Kind.LearningToRank;
    }

    public LearningToRankConfig learningToRank() {
        return (LearningToRankConfig)TaggedUnionUtils.get(this, Kind.LearningToRank);
    }

    public boolean isNer() {
        return this._kind == Kind.Ner;
    }

    public NerInferenceOptions ner() {
        return (NerInferenceOptions)TaggedUnionUtils.get(this, Kind.Ner);
    }

    public boolean isPassThrough() {
        return this._kind == Kind.PassThrough;
    }

    public PassThroughInferenceOptions passThrough() {
        return (PassThroughInferenceOptions)TaggedUnionUtils.get(this, Kind.PassThrough);
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public TextEmbeddingInferenceOptions textEmbedding() {
        return (TextEmbeddingInferenceOptions)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    public boolean isTextExpansion() {
        return this._kind == Kind.TextExpansion;
    }

    public TextExpansionInferenceOptions textExpansion() {
        return (TextExpansionInferenceOptions)TaggedUnionUtils.get(this, Kind.TextExpansion);
    }

    public boolean isQuestionAnswering() {
        return this._kind == Kind.QuestionAnswering;
    }

    public QuestionAnsweringInferenceOptions questionAnswering() {
        return (QuestionAnsweringInferenceOptions)TaggedUnionUtils.get(this, Kind.QuestionAnswering);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceConfigCreateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::regression, RegressionInferenceOptions._DESERIALIZER, "regression");
        op.add(Builder::classification, ClassificationInferenceOptions._DESERIALIZER, "classification");
        op.add(Builder::textClassification, TextClassificationInferenceOptions._DESERIALIZER, "text_classification");
        op.add(Builder::zeroShotClassification, ZeroShotClassificationInferenceOptions._DESERIALIZER, "zero_shot_classification");
        op.add(Builder::fillMask, FillMaskInferenceOptions._DESERIALIZER, "fill_mask");
        op.add(Builder::learningToRank, LearningToRankConfig._DESERIALIZER, "learning_to_rank");
        op.add(Builder::ner, NerInferenceOptions._DESERIALIZER, "ner");
        op.add(Builder::passThrough, PassThroughInferenceOptions._DESERIALIZER, "pass_through");
        op.add(Builder::textEmbedding, TextEmbeddingInferenceOptions._DESERIALIZER, "text_embedding");
        op.add(Builder::textExpansion, TextExpansionInferenceOptions._DESERIALIZER, "text_expansion");
        op.add(Builder::questionAnswering, QuestionAnsweringInferenceOptions._DESERIALIZER, "question_answering");
    }

    public static enum Kind implements JsonEnum
    {
        Regression("regression"),
        Classification("classification"),
        TextClassification("text_classification"),
        ZeroShotClassification("zero_shot_classification"),
        FillMask("fill_mask"),
        LearningToRank("learning_to_rank"),
        Ner("ner"),
        PassThrough("pass_through"),
        TextEmbedding("text_embedding"),
        TextExpansion("text_expansion"),
        QuestionAnswering("question_answering");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceConfigCreate> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> regression(RegressionInferenceOptions v) {
            this._kind = Kind.Regression;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> regression(Function<RegressionInferenceOptions.Builder, ObjectBuilder<RegressionInferenceOptions>> fn) {
            return this.regression(fn.apply(new RegressionInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> classification(ClassificationInferenceOptions v) {
            this._kind = Kind.Classification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> classification(Function<ClassificationInferenceOptions.Builder, ObjectBuilder<ClassificationInferenceOptions>> fn) {
            return this.classification(fn.apply(new ClassificationInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> textClassification(TextClassificationInferenceOptions v) {
            this._kind = Kind.TextClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> textClassification(Function<TextClassificationInferenceOptions.Builder, ObjectBuilder<TextClassificationInferenceOptions>> fn) {
            return this.textClassification(fn.apply(new TextClassificationInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> zeroShotClassification(ZeroShotClassificationInferenceOptions v) {
            this._kind = Kind.ZeroShotClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> zeroShotClassification(Function<ZeroShotClassificationInferenceOptions.Builder, ObjectBuilder<ZeroShotClassificationInferenceOptions>> fn) {
            return this.zeroShotClassification(fn.apply(new ZeroShotClassificationInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> fillMask(FillMaskInferenceOptions v) {
            this._kind = Kind.FillMask;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> fillMask(Function<FillMaskInferenceOptions.Builder, ObjectBuilder<FillMaskInferenceOptions>> fn) {
            return this.fillMask(fn.apply(new FillMaskInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> learningToRank(LearningToRankConfig v) {
            this._kind = Kind.LearningToRank;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> learningToRank(Function<LearningToRankConfig.Builder, ObjectBuilder<LearningToRankConfig>> fn) {
            return this.learningToRank(fn.apply(new LearningToRankConfig.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> ner(NerInferenceOptions v) {
            this._kind = Kind.Ner;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> ner(Function<NerInferenceOptions.Builder, ObjectBuilder<NerInferenceOptions>> fn) {
            return this.ner(fn.apply(new NerInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> passThrough(PassThroughInferenceOptions v) {
            this._kind = Kind.PassThrough;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> passThrough(Function<PassThroughInferenceOptions.Builder, ObjectBuilder<PassThroughInferenceOptions>> fn) {
            return this.passThrough(fn.apply(new PassThroughInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> textEmbedding(TextEmbeddingInferenceOptions v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> textEmbedding(Function<TextEmbeddingInferenceOptions.Builder, ObjectBuilder<TextEmbeddingInferenceOptions>> fn) {
            return this.textEmbedding(fn.apply(new TextEmbeddingInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> textExpansion(TextExpansionInferenceOptions v) {
            this._kind = Kind.TextExpansion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> textExpansion(Function<TextExpansionInferenceOptions.Builder, ObjectBuilder<TextExpansionInferenceOptions>> fn) {
            return this.textExpansion(fn.apply(new TextExpansionInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigCreate> questionAnswering(QuestionAnsweringInferenceOptions v) {
            this._kind = Kind.QuestionAnswering;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigCreate> questionAnswering(Function<QuestionAnsweringInferenceOptions.Builder, ObjectBuilder<QuestionAnsweringInferenceOptions>> fn) {
            return this.questionAnswering(fn.apply(new QuestionAnsweringInferenceOptions.Builder()).build());
        }

        @Override
        public InferenceConfigCreate build() {
            this._checkSingleUse();
            return new InferenceConfigCreate(this);
        }
    }
}

