/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.ml_jobs.JobsRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class MlJobsResponse
implements JsonpSerializable {
    private final List<JobsRecord> jobs;
    public static final JsonpDeserializer<MlJobsResponse> _DESERIALIZER = MlJobsResponse.createMlJobsResponseDeserializer();

    private MlJobsResponse(Builder builder) {
        this.jobs = ApiTypeHelper.unmodifiableRequired(builder.jobs, (Object)this, "jobs");
    }

    public static MlJobsResponse of(Function<Builder, ObjectBuilder<MlJobsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<JobsRecord> jobs() {
        return this.jobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (JobsRecord item0 : this.jobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<MlJobsResponse> createMlJobsResponseDeserializer() {
        JsonpDeserializer<List<JobsRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(JobsRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().jobs((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MlJobsResponse> {
        private List<JobsRecord> jobs;

        public final Builder jobs(List<JobsRecord> list) {
            this.jobs = Builder._listAddAll(this.jobs, list);
            return this;
        }

        public final Builder jobs(JobsRecord value, JobsRecord ... values) {
            this.jobs = Builder._listAdd(this.jobs, value, values);
            return this;
        }

        public final Builder jobs(Function<JobsRecord.Builder, ObjectBuilder<JobsRecord>> fn) {
            return this.jobs(fn.apply(new JobsRecord.Builder()).build(), new JobsRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<JobsRecord> value = JsonpDeserializer.arrayDeserializer(JobsRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.jobs(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlJobsResponse build() {
            this._checkSingleUse();
            return new MlJobsResponse(this);
        }
    }
}

