/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.InferenceEndpoint;
import co.elastic.clients.elasticsearch.inference.TaskTypeGoogleAIStudio;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;

public abstract class InferenceEndpointInfoGoogleAIStudio
extends InferenceEndpoint {
    private final String inferenceId;
    private final TaskTypeGoogleAIStudio taskType;

    protected InferenceEndpointInfoGoogleAIStudio(AbstractBuilder<?> builder) {
        super(builder);
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final TaskTypeGoogleAIStudio taskType() {
        return this.taskType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("inference_id");
        generator.write(this.inferenceId);
        generator.writeKey("task_type");
        this.taskType.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupInferenceEndpointInfoGoogleAIStudioDeserializer(ObjectDeserializer<BuilderT> op) {
        InferenceEndpoint.setupInferenceEndpointDeserializer(op);
        op.add(AbstractBuilder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(AbstractBuilder::taskType, TaskTypeGoogleAIStudio._DESERIALIZER, "task_type");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends InferenceEndpoint.AbstractBuilder<BuilderT> {
        private String inferenceId;
        private TaskTypeGoogleAIStudio taskType;

        public final BuilderT inferenceId(String value) {
            this.inferenceId = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT taskType(TaskTypeGoogleAIStudio value) {
            this.taskType = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

