/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client;

import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

class MultiBufferEntity
extends AbstractHttpEntity
implements AsyncEntityProducer {
    private final Iterable<ByteBuffer> buffers;
    private Iterator<ByteBuffer> iterator;
    private volatile ByteBuffer currentBuffer;
    private final AtomicReference<Exception> exceptionRef;

    MultiBufferEntity(Iterable<ByteBuffer> buffers, ContentType contentType) {
        super(contentType, null, true);
        this.buffers = buffers;
        this.exceptionRef = new AtomicReference();
        this.init();
    }

    public void close() throws IOException {
        this.init();
    }

    private void init() {
        this.iterator = this.buffers.iterator();
        this.currentBuffer = this.iterator.hasNext() ? this.iterator.next().duplicate() : null;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void failed(Exception cause) {
        if (this.exceptionRef.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
        this.writeTo(baos);
        return baos.asInputStream();
    }

    public void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        for (ByteBuffer buffer : this.buffers) {
            channel.write(buffer.duplicate());
        }
    }

    public int available() {
        return this.currentBuffer.remaining();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.currentBuffer == null) {
            channel.endStream();
            return;
        }
        channel.write(this.currentBuffer);
        if (!this.currentBuffer.hasRemaining()) {
            if (this.iterator.hasNext()) {
                this.currentBuffer = this.iterator.next().duplicate();
            } else {
                this.currentBuffer = null;
                channel.endStream();
            }
        }
    }

    public void releaseResources() {
        this.init();
    }
}

