/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.ml.TopClassEntry;
import co.elastic.clients.elasticsearch.ml.TrainedModelEntities;
import co.elastic.clients.elasticsearch.ml.TrainedModelInferenceFeatureImportance;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceResponseResult
implements JsonpSerializable {
    private final List<TrainedModelEntities> entities;
    @Nullable
    private final Boolean isTruncated;
    private final List<List<FieldValue>> predictedValue;
    @Nullable
    private final String predictedValueSequence;
    @Nullable
    private final Double predictionProbability;
    @Nullable
    private final Double predictionScore;
    private final List<TopClassEntry> topClasses;
    @Nullable
    private final String warning;
    private final List<TrainedModelInferenceFeatureImportance> featureImportance;
    public static final JsonpDeserializer<InferenceResponseResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceResponseResult::setupInferenceResponseResultDeserializer);

    private InferenceResponseResult(Builder builder) {
        this.entities = ApiTypeHelper.unmodifiable(builder.entities);
        this.isTruncated = builder.isTruncated;
        this.predictedValue = ApiTypeHelper.unmodifiable(builder.predictedValue);
        this.predictedValueSequence = builder.predictedValueSequence;
        this.predictionProbability = builder.predictionProbability;
        this.predictionScore = builder.predictionScore;
        this.topClasses = ApiTypeHelper.unmodifiable(builder.topClasses);
        this.warning = builder.warning;
        this.featureImportance = ApiTypeHelper.unmodifiable(builder.featureImportance);
    }

    public static InferenceResponseResult of(Function<Builder, ObjectBuilder<InferenceResponseResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TrainedModelEntities> entities() {
        return this.entities;
    }

    @Nullable
    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final List<List<FieldValue>> predictedValue() {
        return this.predictedValue;
    }

    @Nullable
    public final String predictedValueSequence() {
        return this.predictedValueSequence;
    }

    @Nullable
    public final Double predictionProbability() {
        return this.predictionProbability;
    }

    @Nullable
    public final Double predictionScore() {
        return this.predictionScore;
    }

    public final List<TopClassEntry> topClasses() {
        return this.topClasses;
    }

    @Nullable
    public final String warning() {
        return this.warning;
    }

    public final List<TrainedModelInferenceFeatureImportance> featureImportance() {
        return this.featureImportance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.entities)) {
            generator.writeKey("entities");
            generator.writeStartArray();
            for (TrainedModelEntities trainedModelEntities : this.entities) {
                trainedModelEntities.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.isTruncated != null) {
            generator.writeKey("is_truncated");
            generator.write(this.isTruncated.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.predictedValue)) {
            generator.writeKey("predicted_value");
            generator.writeStartArray();
            for (List list : this.predictedValue) {
                generator.writeStartArray();
                if (list != null) {
                    for (FieldValue item1 : list) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.predictedValueSequence != null) {
            generator.writeKey("predicted_value_sequence");
            generator.write(this.predictedValueSequence);
        }
        if (this.predictionProbability != null) {
            generator.writeKey("prediction_probability");
            generator.write(this.predictionProbability.doubleValue());
        }
        if (this.predictionScore != null) {
            generator.writeKey("prediction_score");
            generator.write(this.predictionScore.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.topClasses)) {
            generator.writeKey("top_classes");
            generator.writeStartArray();
            for (TopClassEntry topClassEntry : this.topClasses) {
                topClassEntry.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.warning != null) {
            generator.writeKey("warning");
            generator.write(this.warning);
        }
        if (ApiTypeHelper.isDefined(this.featureImportance)) {
            generator.writeKey("feature_importance");
            generator.writeStartArray();
            for (TrainedModelInferenceFeatureImportance trainedModelInferenceFeatureImportance : this.featureImportance) {
                trainedModelInferenceFeatureImportance.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceResponseResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::entities, JsonpDeserializer.arrayDeserializer(TrainedModelEntities._DESERIALIZER), "entities");
        op.add(Builder::isTruncated, JsonpDeserializer.booleanDeserializer(), "is_truncated");
        op.add(Builder::predictedValue, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER)), "predicted_value");
        op.add(Builder::predictedValueSequence, JsonpDeserializer.stringDeserializer(), "predicted_value_sequence");
        op.add(Builder::predictionProbability, JsonpDeserializer.doubleDeserializer(), "prediction_probability");
        op.add(Builder::predictionScore, JsonpDeserializer.doubleDeserializer(), "prediction_score");
        op.add(Builder::topClasses, JsonpDeserializer.arrayDeserializer(TopClassEntry._DESERIALIZER), "top_classes");
        op.add(Builder::warning, JsonpDeserializer.stringDeserializer(), "warning");
        op.add(Builder::featureImportance, JsonpDeserializer.arrayDeserializer(TrainedModelInferenceFeatureImportance._DESERIALIZER), "feature_importance");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceResponseResult> {
        @Nullable
        private List<TrainedModelEntities> entities;
        @Nullable
        private Boolean isTruncated;
        @Nullable
        private List<List<FieldValue>> predictedValue;
        @Nullable
        private String predictedValueSequence;
        @Nullable
        private Double predictionProbability;
        @Nullable
        private Double predictionScore;
        @Nullable
        private List<TopClassEntry> topClasses;
        @Nullable
        private String warning;
        @Nullable
        private List<TrainedModelInferenceFeatureImportance> featureImportance;

        public final Builder entities(List<TrainedModelEntities> list) {
            this.entities = Builder._listAddAll(this.entities, list);
            return this;
        }

        public final Builder entities(TrainedModelEntities value, TrainedModelEntities ... values) {
            this.entities = Builder._listAdd(this.entities, value, values);
            return this;
        }

        public final Builder entities(Function<TrainedModelEntities.Builder, ObjectBuilder<TrainedModelEntities>> fn) {
            return this.entities(fn.apply(new TrainedModelEntities.Builder()).build(), new TrainedModelEntities[0]);
        }

        public final Builder isTruncated(@Nullable Boolean value) {
            this.isTruncated = value;
            return this;
        }

        public final Builder predictedValue(List<List<FieldValue>> list) {
            this.predictedValue = Builder._listAddAll(this.predictedValue, list);
            return this;
        }

        public final Builder predictedValue(List<FieldValue> value, List<FieldValue> ... values) {
            this.predictedValue = Builder._listAdd(this.predictedValue, value, values);
            return this;
        }

        public final Builder predictedValueSequence(@Nullable String value) {
            this.predictedValueSequence = value;
            return this;
        }

        public final Builder predictionProbability(@Nullable Double value) {
            this.predictionProbability = value;
            return this;
        }

        public final Builder predictionScore(@Nullable Double value) {
            this.predictionScore = value;
            return this;
        }

        public final Builder topClasses(List<TopClassEntry> list) {
            this.topClasses = Builder._listAddAll(this.topClasses, list);
            return this;
        }

        public final Builder topClasses(TopClassEntry value, TopClassEntry ... values) {
            this.topClasses = Builder._listAdd(this.topClasses, value, values);
            return this;
        }

        public final Builder topClasses(Function<TopClassEntry.Builder, ObjectBuilder<TopClassEntry>> fn) {
            return this.topClasses(fn.apply(new TopClassEntry.Builder()).build(), new TopClassEntry[0]);
        }

        public final Builder warning(@Nullable String value) {
            this.warning = value;
            return this;
        }

        public final Builder featureImportance(List<TrainedModelInferenceFeatureImportance> list) {
            this.featureImportance = Builder._listAddAll(this.featureImportance, list);
            return this;
        }

        public final Builder featureImportance(TrainedModelInferenceFeatureImportance value, TrainedModelInferenceFeatureImportance ... values) {
            this.featureImportance = Builder._listAdd(this.featureImportance, value, values);
            return this;
        }

        public final Builder featureImportance(Function<TrainedModelInferenceFeatureImportance.Builder, ObjectBuilder<TrainedModelInferenceFeatureImportance>> fn) {
            return this.featureImportance(fn.apply(new TrainedModelInferenceFeatureImportance.Builder()).build(), new TrainedModelInferenceFeatureImportance[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceResponseResult build() {
            this._checkSingleUse();
            return new InferenceResponseResult(this);
        }
    }
}

