/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RateLimitSetting
implements JsonpSerializable {
    @Nullable
    private final Integer requestsPerMinute;
    public static final JsonpDeserializer<RateLimitSetting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RateLimitSetting::setupRateLimitSettingDeserializer);

    private RateLimitSetting(Builder builder) {
        this.requestsPerMinute = builder.requestsPerMinute;
    }

    public static RateLimitSetting of(Function<Builder, ObjectBuilder<RateLimitSetting>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer requestsPerMinute() {
        return this.requestsPerMinute;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.requestsPerMinute != null) {
            generator.writeKey("requests_per_minute");
            generator.write(this.requestsPerMinute.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRateLimitSettingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::requestsPerMinute, JsonpDeserializer.integerDeserializer(), "requests_per_minute");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RateLimitSetting> {
        @Nullable
        private Integer requestsPerMinute;

        public final Builder requestsPerMinute(@Nullable Integer value) {
            this.requestsPerMinute = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RateLimitSetting build() {
            this._checkSingleUse();
            return new RateLimitSetting(this);
        }
    }
}

