/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.SearchIdle;
import co.elastic.clients.elasticsearch.indices.SlowlogSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SettingsSearch
implements JsonpSerializable {
    @Nullable
    private final SearchIdle idle;
    @Nullable
    private final SlowlogSettings slowlog;
    public static final JsonpDeserializer<SettingsSearch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SettingsSearch::setupSettingsSearchDeserializer);

    private SettingsSearch(Builder builder) {
        this.idle = builder.idle;
        this.slowlog = builder.slowlog;
    }

    public static SettingsSearch of(Function<Builder, ObjectBuilder<SettingsSearch>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SearchIdle idle() {
        return this.idle;
    }

    @Nullable
    public final SlowlogSettings slowlog() {
        return this.slowlog;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.idle != null) {
            generator.writeKey("idle");
            this.idle.serialize(generator, mapper);
        }
        if (this.slowlog != null) {
            generator.writeKey("slowlog");
            this.slowlog.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSettingsSearchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::idle, SearchIdle._DESERIALIZER, "idle");
        op.add(Builder::slowlog, SlowlogSettings._DESERIALIZER, "slowlog");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SettingsSearch> {
        @Nullable
        private SearchIdle idle;
        @Nullable
        private SlowlogSettings slowlog;

        public final Builder idle(@Nullable SearchIdle value) {
            this.idle = value;
            return this;
        }

        public final Builder idle(Function<SearchIdle.Builder, ObjectBuilder<SearchIdle>> fn) {
            return this.idle(fn.apply(new SearchIdle.Builder()).build());
        }

        public final Builder slowlog(@Nullable SlowlogSettings value) {
            this.slowlog = value;
            return this;
        }

        public final Builder slowlog(Function<SlowlogSettings.Builder, ObjectBuilder<SlowlogSettings>> fn) {
            return this.slowlog(fn.apply(new SlowlogSettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SettingsSearch build() {
            this._checkSingleUse();
            return new SettingsSearch(this);
        }
    }
}

