/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SparseVectorProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean store;
    public static final JsonpDeserializer<SparseVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseVectorProperty::setupSparseVectorPropertyDeserializer);

    private SparseVectorProperty(Builder builder) {
        super(builder);
        this.store = builder.store;
    }

    public static SparseVectorProperty of(Function<Builder, ObjectBuilder<SparseVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.SparseVector;
    }

    @Nullable
    public final Boolean store() {
        return this.store;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "sparse_vector");
        super.serializeInternal(generator, mapper);
        if (this.store != null) {
            generator.writeKey("store");
            generator.write(this.store.booleanValue());
        }
    }

    protected static void setupSparseVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::store, JsonpDeserializer.booleanDeserializer(), "store");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SparseVectorProperty> {
        @Nullable
        private Boolean store;

        public final Builder store(@Nullable Boolean value) {
            this.store = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SparseVectorProperty build() {
            this._checkSingleUse();
            return new SparseVectorProperty(this);
        }
    }
}

