/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FiltersBucket
extends MultiBucketBase {
    @Nullable
    private final String key;
    public static final JsonpDeserializer<FiltersBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FiltersBucket::setupFiltersBucketDeserializer);

    private FiltersBucket(Builder builder) {
        super(builder);
        this.key = builder.key;
    }

    public static FiltersBucket of(Function<Builder, ObjectBuilder<FiltersBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
    }

    protected static void setupFiltersBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FiltersBucket> {
        @Nullable
        private String key;

        public final Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FiltersBucket build() {
            this._checkSingleUse();
            return new FiltersBucket(this);
        }
    }
}

