/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.SparseEmbeddingResult;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

public abstract class SparseEmbeddingInferenceResult
implements JsonpSerializable {
    private final List<SparseEmbeddingResult> sparseEmbedding;

    protected SparseEmbeddingInferenceResult(AbstractBuilder<?> builder) {
        this.sparseEmbedding = ApiTypeHelper.unmodifiableRequired(builder.sparseEmbedding, (Object)this, "sparseEmbedding");
    }

    public final List<SparseEmbeddingResult> sparseEmbedding() {
        return this.sparseEmbedding;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.sparseEmbedding)) {
            generator.writeKey("sparse_embedding");
            generator.writeStartArray();
            for (SparseEmbeddingResult item0 : this.sparseEmbedding) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSparseEmbeddingInferenceResultDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::sparseEmbedding, JsonpDeserializer.arrayDeserializer(SparseEmbeddingResult._DESERIALIZER), "sparse_embedding");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private List<SparseEmbeddingResult> sparseEmbedding;

        public final BuilderT sparseEmbedding(List<SparseEmbeddingResult> list) {
            this.sparseEmbedding = AbstractBuilder._listAddAll(this.sparseEmbedding, list);
            return (BuilderT)this.self();
        }

        public final BuilderT sparseEmbedding(SparseEmbeddingResult value, SparseEmbeddingResult ... values) {
            this.sparseEmbedding = AbstractBuilder._listAdd(this.sparseEmbedding, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT sparseEmbedding(Function<SparseEmbeddingResult.Builder, ObjectBuilder<SparseEmbeddingResult>> fn) {
            return this.sparseEmbedding(fn.apply(new SparseEmbeddingResult.Builder()).build(), new SparseEmbeddingResult[0]);
        }

        @Override
        protected abstract BuilderT self();
    }
}

