/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransportBase;
import co.elastic.clients.transport.ElasticsearchTransportConfig;
import co.elastic.clients.transport.Transport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.rest5_client.Rest5ClientHttpClient;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.Rest5ClientBuilder;
import java.util.Base64;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class Rest5ClientTransport
extends ElasticsearchTransportBase {
    private final Rest5Client restClient;

    public Rest5ClientTransport(ElasticsearchTransportConfig config) {
        this(Rest5ClientTransport.buildRest5Client(config), config.mapper(), Rest5ClientOptions.of(config.transportOptions()), config.instrumentation());
    }

    public Rest5ClientTransport(Rest5Client restClient, JsonpMapper jsonpMapper) {
        this(restClient, jsonpMapper, null);
    }

    public Rest5ClientTransport(Rest5Client restClient, JsonpMapper jsonpMapper, Rest5ClientOptions options) {
        super(new Rest5ClientHttpClient(restClient), options, jsonpMapper, null);
        this.restClient = restClient;
    }

    public Rest5ClientTransport(Rest5Client restClient, JsonpMapper jsonpMapper, Rest5ClientOptions options, Instrumentation instrumentation) {
        super(new Rest5ClientHttpClient(restClient), options, jsonpMapper, instrumentation);
        this.restClient = restClient;
    }

    private static Rest5Client buildRest5Client(ElasticsearchTransportConfig config) {
        Rest5ClientBuilder restClientBuilder = Rest5Client.builder(config.hosts());
        if (config.username() != null && config.password() != null) {
            String cred = Base64.getEncoder().encodeToString((config.username() + ":" + config.password()).getBytes());
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Basic " + cred))});
        } else if (config.apiKey() != null) {
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("ApiKey " + config.apiKey()))});
        } else if (config.token() != null) {
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Bearer " + config.token()))});
        }
        if (config.sslContext() != null) {
            restClientBuilder.setSSLContext(config.sslContext());
        }
        restClientBuilder.setCompressionEnabled(config.useCompression());
        return restClientBuilder.build();
    }

    public Rest5Client restClient() {
        return this.restClient;
    }

    @Override
    public Transport withOptions(@Nullable TransportOptions options) {
        return new Rest5ClientTransport(this.restClient, this.mapper, Rest5ClientOptions.of(options), this.instrumentation);
    }

    @Override
    protected ElasticsearchTransportBase cloneWith(TransportOptions options, JsonpMapper mapper, Instrumentation instrumentation) {
        return new Rest5ClientTransport(this.restClient, mapper != null ? mapper : this.mapper, Rest5ClientOptions.of(options != null ? options : this.transportOptions), instrumentation != null ? instrumentation : this.instrumentation);
    }
}

