/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.delegate_pki.Authentication;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DelegatePkiResponse
implements JsonpSerializable {
    private final String accessToken;
    private final long expiresIn;
    private final String type;
    @Nullable
    private final Authentication authentication;
    public static final JsonpDeserializer<DelegatePkiResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelegatePkiResponse::setupDelegatePkiResponseDeserializer);

    private DelegatePkiResponse(Builder builder) {
        this.accessToken = ApiTypeHelper.requireNonNull(builder.accessToken, this, "accessToken");
        this.expiresIn = ApiTypeHelper.requireNonNull(builder.expiresIn, (Object)this, "expiresIn", 0L);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.authentication = builder.authentication;
    }

    public static DelegatePkiResponse of(Function<Builder, ObjectBuilder<DelegatePkiResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final long expiresIn() {
        return this.expiresIn;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Authentication authentication() {
        return this.authentication;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        generator.writeKey("expires_in");
        generator.write(this.expiresIn);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.authentication != null) {
            generator.writeKey("authentication");
            this.authentication.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDelegatePkiResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::expiresIn, JsonpDeserializer.longDeserializer(), "expires_in");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::authentication, Authentication._DESERIALIZER, "authentication");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DelegatePkiResponse> {
        private String accessToken;
        private Long expiresIn;
        private String type;
        @Nullable
        private Authentication authentication;

        public final Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder expiresIn(long value) {
            this.expiresIn = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder authentication(@Nullable Authentication value) {
            this.authentication = value;
            return this;
        }

        public final Builder authentication(Function<Authentication.Builder, ObjectBuilder<Authentication>> fn) {
            return this.authentication(fn.apply(new Authentication.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DelegatePkiResponse build() {
            this._checkSingleUse();
            return new DelegatePkiResponse(this);
        }
    }
}

