/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CalendarInterval;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedBounds;
import co.elastic.clients.elasticsearch._types.aggregations.FieldDateMath;
import co.elastic.clients.elasticsearch.transform.PivotGroupBy;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateHistogramAggregation
extends BucketAggregationBase
implements AggregationVariant,
PivotGroupByVariant,
JsonpSerializable {
    @Nullable
    private final CalendarInterval calendarInterval;
    @Nullable
    private final ExtendedBounds<FieldDateMath> extendedBounds;
    @Nullable
    private final ExtendedBounds<FieldDateMath> hardBounds;
    @Nullable
    private final String field;
    @Nullable
    private final Time fixedInterval;
    @Nullable
    private final String format;
    @Nullable
    private final Time interval;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final DateTime missing;
    @Nullable
    private final Time offset;
    private final List<NamedValue<SortOrder>> order;
    private final Map<String, JsonData> params;
    @Nullable
    private final Script script;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<DateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramAggregation::setupDateHistogramAggregationDeserializer);

    private DateHistogramAggregation(Builder builder) {
        this.calendarInterval = builder.calendarInterval;
        this.extendedBounds = builder.extendedBounds;
        this.hardBounds = builder.hardBounds;
        this.field = builder.field;
        this.fixedInterval = builder.fixedInterval;
        this.format = builder.format;
        this.interval = builder.interval;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.order = ApiTypeHelper.unmodifiable(builder.order);
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.script = builder.script;
        this.timeZone = builder.timeZone;
        this.keyed = builder.keyed;
    }

    public static DateHistogramAggregation of(Function<Builder, ObjectBuilder<DateHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.DateHistogram;
    }

    @Override
    public PivotGroupBy.Kind _pivotGroupByKind() {
        return PivotGroupBy.Kind.DateHistogram;
    }

    @Nullable
    public final CalendarInterval calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final ExtendedBounds<FieldDateMath> extendedBounds() {
        return this.extendedBounds;
    }

    @Nullable
    public final ExtendedBounds<FieldDateMath> hardBounds() {
        return this.hardBounds;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Deprecated
    @Nullable
    public final Time interval() {
        return this.interval;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final DateTime missing() {
        return this.missing;
    }

    @Nullable
    public final Time offset() {
        return this.offset;
    }

    public final List<NamedValue<SortOrder>> order() {
        return this.order;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            this.calendarInterval.serialize(generator, mapper);
        }
        if (this.extendedBounds != null) {
            generator.writeKey("extended_bounds");
            this.extendedBounds.serialize(generator, mapper);
        }
        if (this.hardBounds != null) {
            generator.writeKey("hard_bounds");
            this.hardBounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            this.fixedInterval.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            this.interval.serialize(generator, mapper);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            this.offset.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (NamedValue<SortOrder> namedValue : this.order) {
                generator.writeStartObject();
                generator.writeKey(namedValue.name());
                namedValue.value().serialize(generator, mapper);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry entry : this.params.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDateHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::calendarInterval, CalendarInterval._DESERIALIZER, "calendar_interval");
        op.add(Builder::extendedBounds, ExtendedBounds.createExtendedBoundsDeserializer(FieldDateMath._DESERIALIZER), "extended_bounds");
        op.add(Builder::hardBounds, ExtendedBounds.createExtendedBoundsDeserializer(FieldDateMath._DESERIALIZER), "hard_bounds");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::missing, DateTime._DESERIALIZER, "missing");
        op.add(Builder::offset, Time._DESERIALIZER, "offset");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(NamedValue.deserializer(() -> SortOrder._DESERIALIZER)), "order");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateHistogramAggregation> {
        @Nullable
        private CalendarInterval calendarInterval;
        @Nullable
        private ExtendedBounds<FieldDateMath> extendedBounds;
        @Nullable
        private ExtendedBounds<FieldDateMath> hardBounds;
        @Nullable
        private String field;
        @Nullable
        private Time fixedInterval;
        @Nullable
        private String format;
        @Nullable
        private Time interval;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private DateTime missing;
        @Nullable
        private Time offset;
        @Nullable
        private List<NamedValue<SortOrder>> order;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Script script;
        @Nullable
        private String timeZone;
        @Nullable
        private Boolean keyed;

        public final Builder calendarInterval(@Nullable CalendarInterval value) {
            this.calendarInterval = value;
            return this;
        }

        public final Builder extendedBounds(@Nullable ExtendedBounds<FieldDateMath> value) {
            this.extendedBounds = value;
            return this;
        }

        public final Builder extendedBounds(Function<ExtendedBounds.Builder<FieldDateMath>, ObjectBuilder<ExtendedBounds<FieldDateMath>>> fn) {
            return this.extendedBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public final Builder hardBounds(@Nullable ExtendedBounds<FieldDateMath> value) {
            this.hardBounds = value;
            return this;
        }

        public final Builder hardBounds(Function<ExtendedBounds.Builder<FieldDateMath>, ObjectBuilder<ExtendedBounds<FieldDateMath>>> fn) {
            return this.hardBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder fixedInterval(@Nullable Time value) {
            this.fixedInterval = value;
            return this;
        }

        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Deprecated
        public final Builder interval(@Nullable Time value) {
            this.interval = value;
            return this;
        }

        @Deprecated
        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder missing(@Nullable DateTime value) {
            this.missing = value;
            return this;
        }

        public final Builder offset(@Nullable Time value) {
            this.offset = value;
            return this;
        }

        public final Builder offset(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.offset(fn.apply(new Time.Builder()).build());
        }

        public final Builder order(List<NamedValue<SortOrder>> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        public final Builder order(NamedValue<SortOrder> value, NamedValue<SortOrder> ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateHistogramAggregation build() {
            this._checkSingleUse();
            return new DateHistogramAggregation(this);
        }
    }
}

