/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class CurrentNode
implements JsonpSerializable {
    private final String id;
    private final String name;
    private final List<NodeRole> roles;
    private final Map<String, String> attributes;
    private final String transportAddress;
    private final int weightRanking;
    public static final JsonpDeserializer<CurrentNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CurrentNode::setupCurrentNodeDeserializer);

    private CurrentNode(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.weightRanking = ApiTypeHelper.requireNonNull(builder.weightRanking, (Object)this, "weightRanking", 0);
    }

    public static CurrentNode of(Function<Builder, ObjectBuilder<CurrentNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final int weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("weight_ranking");
        generator.write(this.weightRanking);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCurrentNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CurrentNode> {
        private String id;
        private String name;
        private List<NodeRole> roles;
        private Map<String, String> attributes;
        private String transportAddress;
        private Integer weightRanking;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder weightRanking(int value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CurrentNode build() {
            this._checkSingleUse();
            return new CurrentNode(this);
        }
    }
}

