/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeRelation;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class RangeQueryBase<T>
extends QueryBase {
    @Nullable
    private final RangeRelation relation;
    @Nullable
    private final T gt;
    @Nullable
    private final T gte;
    @Nullable
    private final T lt;
    @Nullable
    private final T lte;
    @Nullable
    private final T from;
    @Nullable
    private final T to;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    protected RangeQueryBase(AbstractBuilder<T, ?> builder) {
        super(builder);
        this.relation = builder.relation;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.from = builder.from;
        this.to = builder.to;
        this.tSerializer = builder.tSerializer;
    }

    @Nullable
    public final RangeRelation relation() {
        return this.relation;
    }

    @Nullable
    public final T gt() {
        return this.gt;
    }

    @Nullable
    public final T gte() {
        return this.gte;
    }

    @Nullable
    public final T lt() {
        return this.lt;
    }

    @Nullable
    public final T lte() {
        return this.lte;
    }

    @Deprecated
    @Nullable
    public final T from() {
        return this.from;
    }

    @Deprecated
    @Nullable
    public final T to() {
        return this.to;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
        if (this.gt != null) {
            generator.writeKey("gt");
            JsonpUtils.serialize(this.gt, generator, this.tSerializer, mapper);
        }
        if (this.gte != null) {
            generator.writeKey("gte");
            JsonpUtils.serialize(this.gte, generator, this.tSerializer, mapper);
        }
        if (this.lt != null) {
            generator.writeKey("lt");
            JsonpUtils.serialize(this.lt, generator, this.tSerializer, mapper);
        }
        if (this.lte != null) {
            generator.writeKey("lte");
            JsonpUtils.serialize(this.lte, generator, this.tSerializer, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            JsonpUtils.serialize(this.from, generator, this.tSerializer, mapper);
        }
        if (this.to != null) {
            generator.writeKey("to");
            JsonpUtils.serialize(this.to, generator, this.tSerializer, mapper);
        }
    }

    protected static <T, BuilderT extends AbstractBuilder<T, BuilderT>> void setupRangeQueryBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<T> tDeserializer) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(AbstractBuilder::relation, RangeRelation._DESERIALIZER, "relation");
        op.add(AbstractBuilder::gt, tDeserializer, "gt");
        op.add(AbstractBuilder::gte, tDeserializer, "gte");
        op.add(AbstractBuilder::lt, tDeserializer, "lt");
        op.add(AbstractBuilder::lte, tDeserializer, "lte");
        op.add(AbstractBuilder::from, tDeserializer, "from");
        op.add(AbstractBuilder::to, tDeserializer, "to");
    }

    public static abstract class AbstractBuilder<T, BuilderT extends AbstractBuilder<T, BuilderT>>
    extends QueryBase.AbstractBuilder<BuilderT> {
        @Nullable
        private RangeRelation relation;
        @Nullable
        private T gt;
        @Nullable
        private T gte;
        @Nullable
        private T lt;
        @Nullable
        private T lte;
        @Nullable
        private T from;
        @Nullable
        private T to;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public final BuilderT relation(@Nullable RangeRelation value) {
            this.relation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT gt(@Nullable T value) {
            this.gt = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT gte(@Nullable T value) {
            this.gte = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT lt(@Nullable T value) {
            this.lt = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT lte(@Nullable T value) {
            this.lte = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Deprecated
        public final BuilderT from(@Nullable T value) {
            this.from = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Deprecated
        public final BuilderT to(@Nullable T value) {
            this.to = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

