/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StringStatsAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Integer maxLength;
    @Nullable
    private final Double avgLength;
    @Nullable
    private final Double entropy;
    private final Map<String, Double> distribution;
    @Nullable
    private final String minLengthAsString;
    @Nullable
    private final String maxLengthAsString;
    @Nullable
    private final String avgLengthAsString;
    public static final JsonpDeserializer<StringStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringStatsAggregate::setupStringStatsAggregateDeserializer);

    private StringStatsAggregate(Builder builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.avgLength = builder.avgLength;
        this.entropy = builder.entropy;
        this.distribution = ApiTypeHelper.unmodifiable(builder.distribution);
        this.minLengthAsString = builder.minLengthAsString;
        this.maxLengthAsString = builder.maxLengthAsString;
        this.avgLengthAsString = builder.avgLengthAsString;
    }

    public static StringStatsAggregate of(Function<Builder, ObjectBuilder<StringStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.StringStats;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Integer minLength() {
        return this.minLength;
    }

    @Nullable
    public final Integer maxLength() {
        return this.maxLength;
    }

    @Nullable
    public final Double avgLength() {
        return this.avgLength;
    }

    @Nullable
    public final Double entropy() {
        return this.entropy;
    }

    public final Map<String, Double> distribution() {
        return this.distribution;
    }

    @Nullable
    public final String minLengthAsString() {
        return this.minLengthAsString;
    }

    @Nullable
    public final String maxLengthAsString() {
        return this.maxLengthAsString;
    }

    @Nullable
    public final String avgLengthAsString() {
        return this.avgLengthAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        if (this.minLength != null) {
            generator.writeKey("min_length");
            generator.write(this.minLength.intValue());
        }
        if (this.maxLength != null) {
            generator.writeKey("max_length");
            generator.write(this.maxLength.intValue());
        }
        if (this.avgLength != null) {
            generator.writeKey("avg_length");
            generator.write(this.avgLength.doubleValue());
        }
        if (this.entropy != null) {
            generator.writeKey("entropy");
            generator.write(this.entropy.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.distribution)) {
            generator.writeKey("distribution");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.distribution.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        if (this.minLengthAsString != null) {
            generator.writeKey("min_length_as_string");
            generator.write(this.minLengthAsString);
        }
        if (this.maxLengthAsString != null) {
            generator.writeKey("max_length_as_string");
            generator.write(this.maxLengthAsString);
        }
        if (this.avgLengthAsString != null) {
            generator.writeKey("avg_length_as_string");
            generator.write(this.avgLengthAsString);
        }
    }

    protected static void setupStringStatsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::minLength, JsonpDeserializer.integerDeserializer(), "min_length");
        op.add(Builder::maxLength, JsonpDeserializer.integerDeserializer(), "max_length");
        op.add(Builder::avgLength, JsonpDeserializer.doubleDeserializer(), "avg_length");
        op.add(Builder::entropy, JsonpDeserializer.doubleDeserializer(), "entropy");
        op.add(Builder::distribution, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "distribution");
        op.add(Builder::minLengthAsString, JsonpDeserializer.stringDeserializer(), "min_length_as_string");
        op.add(Builder::maxLengthAsString, JsonpDeserializer.stringDeserializer(), "max_length_as_string");
        op.add(Builder::avgLengthAsString, JsonpDeserializer.stringDeserializer(), "avg_length_as_string");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringStatsAggregate> {
        private Long count;
        @Nullable
        private Integer minLength;
        @Nullable
        private Integer maxLength;
        @Nullable
        private Double avgLength;
        @Nullable
        private Double entropy;
        @Nullable
        private Map<String, Double> distribution;
        @Nullable
        private String minLengthAsString;
        @Nullable
        private String maxLengthAsString;
        @Nullable
        private String avgLengthAsString;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder minLength(@Nullable Integer value) {
            this.minLength = value;
            return this;
        }

        public final Builder maxLength(@Nullable Integer value) {
            this.maxLength = value;
            return this;
        }

        public final Builder avgLength(@Nullable Double value) {
            this.avgLength = value;
            return this;
        }

        public final Builder entropy(@Nullable Double value) {
            this.entropy = value;
            return this;
        }

        public final Builder distribution(Map<String, Double> map) {
            this.distribution = Builder._mapPutAll(this.distribution, map);
            return this;
        }

        public final Builder distribution(String key, Double value) {
            this.distribution = Builder._mapPut(this.distribution, key, value);
            return this;
        }

        public final Builder minLengthAsString(@Nullable String value) {
            this.minLengthAsString = value;
            return this;
        }

        public final Builder maxLengthAsString(@Nullable String value) {
            this.maxLengthAsString = value;
            return this;
        }

        public final Builder avgLengthAsString(@Nullable String value) {
            this.avgLengthAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringStatsAggregate build() {
            this._checkSingleUse();
            return new StringStatsAggregate(this);
        }
    }
}

