/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycle;
import co.elastic.clients.elasticsearch.indices.PutDataLifecycleResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataLifecycleRequest
extends RequestBase
implements JsonpSerializable {
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    @Nullable
    private final Time timeout;
    private final DataStreamLifecycle lifecycle;
    public static final JsonpDeserializer<PutDataLifecycleRequest> _DESERIALIZER = PutDataLifecycleRequest.createPutDataLifecycleRequestDeserializer();
    public static final Endpoint<PutDataLifecycleRequest, PutDataLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDataLifecycleRequest, PutDataLifecycleResponse>("es/indices.put_data_lifecycle", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_lifecycle");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDataLifecycleResponse._DESERIALIZER);

    private PutDataLifecycleRequest(Builder builder) {
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.timeout = builder.timeout;
        this.lifecycle = ApiTypeHelper.requireNonNull(builder.lifecycle, this, "lifecycle");
    }

    public static PutDataLifecycleRequest of(Function<Builder, ObjectBuilder<PutDataLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final DataStreamLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.lifecycle.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutDataLifecycleRequest> createPutDataLifecycleRequestDeserializer() {
        JsonpDeserializer<DataStreamLifecycle> valueDeserializer = DataStreamLifecycle._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().lifecycle((DataStreamLifecycle)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDataLifecycleRequest> {
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Time masterTimeout;
        private List<String> name;
        @Nullable
        private Time timeout;
        private DataStreamLifecycle lifecycle;

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder lifecycle(DataStreamLifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<DataStreamLifecycle.Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
            return this.lifecycle(fn.apply(new DataStreamLifecycle.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            DataStreamLifecycle value = DataStreamLifecycle._DESERIALIZER.deserialize(parser, mapper);
            return this.lifecycle(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataLifecycleRequest build() {
            this._checkSingleUse();
            return new PutDataLifecycleRequest(this);
        }
    }
}

